/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thenatekirby.babel.Babel;
import com.thenatekirby.babel.recipe.IExternalRecipe;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;

public class ExternalRecipeProvider
implements IDataProvider {
    private final DataGenerator dataGenerator;
    private final String modId;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public ExternalRecipeProvider(@Nonnull String modId, @Nonnull DataGenerator dataGenerator) {
        this.modId = modId;
        this.dataGenerator = dataGenerator;
    }

    public void func_200398_a(@Nonnull DirectoryCache cache) throws IOException {
        Path path = this.dataGenerator.func_200391_b();
        HashSet set = Sets.newHashSet();
        this.registerRecipes(recipe -> {
            if (!set.add(recipe.getId())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.getId());
            }
            ExternalRecipeProvider.saveRecipe(cache, recipe.getRecipeJson(), path.resolve("data/" + recipe.getId().func_110624_b() + "/recipes/" + recipe.getId().func_110623_a() + ".json"));
        });
    }

    public void registerRecipes(Consumer<IExternalRecipe> consumer) {
    }

    private static void saveRecipe(DirectoryCache cache, JsonObject recipeJson, Path outputPath) {
        try {
            String json = GSON.toJson((JsonElement)recipeJson);
            String hash = field_208307_a.hashUnencodedChars((CharSequence)json).toString();
            if (!Objects.equals(cache.func_208323_a(outputPath), hash) || !Files.exists(outputPath, new LinkOption[0])) {
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(outputPath, new OpenOption[0]);){
                    bufferedwriter.write(json);
                }
            }
            cache.func_208316_a(outputPath, hash);
        }
        catch (IOException ioexception) {
            Babel.getLogger().error("babel: Couldn't save recipe {}", (Object)recipeJson, (Object)ioexception);
        }
    }

    @Nonnull
    public String func_200397_b() {
        return this.modId + ":external_recipes";
    }
}

