/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core.inventory;

import com.thenatekirby.babel.core.energy.EnergyBuffer;
import com.thenatekirby.babel.core.slots.ItemSlot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SlotConfiguration<T extends SlotConfiguration> {
    private List<ItemSlot> inputItemSlots = new ArrayList<ItemSlot>();
    private List<ItemSlot> outputItemSlots = new ArrayList<ItemSlot>();
    private List<ItemSlot> auxilaryItemSlots = new ArrayList<ItemSlot>();
    private EnergyBuffer energyBuffer = EnergyBuffer.ZERO;

    protected SlotConfiguration() {
    }

    public static <T extends SlotConfiguration> SlotConfiguration<T> make() {
        return new SlotConfiguration<T>();
    }

    public T withInputs(ItemSlot ... itemSlots) {
        this.inputItemSlots.addAll(Arrays.asList(itemSlots));
        return (T)this;
    }

    public T withOutputs(ItemSlot ... itemSlots) {
        this.outputItemSlots.addAll(Arrays.asList(itemSlots));
        return (T)this;
    }

    public T withEnergyBuffer(EnergyBuffer buffer) {
        this.energyBuffer = buffer;
        return (T)this;
    }

    public T withAuxiliaries(ItemSlot ... itemSlots) {
        this.auxilaryItemSlots.addAll(Arrays.asList(itemSlots));
        return (T)this;
    }

    public List<ItemSlot> getInputItemSlots() {
        return this.inputItemSlots;
    }

    public List<ItemSlot> getOutputItemSlots() {
        return this.outputItemSlots;
    }

    public List<ItemSlot> getAuxilaryItemSlots() {
        return this.auxilaryItemSlots;
    }

    public EnergyBuffer getEnergyBuffer() {
        return this.energyBuffer;
    }
}

