/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.thenatekirby.babel.core.container.BabelContainer;
import com.thenatekirby.babel.core.gui.GuiRenderer;
import com.thenatekirby.babel.core.slots.BabelSlot;
import com.thenatekirby.babel.gui.SlotGuiWidget;
import com.thenatekirby.babel.mod.BabelTextureLocations;
import com.thenatekirby.babel.util.InventoryUtil;
import com.thenatekirby.babel.util.RenderUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class BabelContainerScreen<T extends BabelContainer>
extends ContainerScreen<T> {
    public BabelContainerScreen(T screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        GuiRenderer guiRenderer = new GuiRenderer(this);
        ResourceLocation backgroundResourceLocation = this.getBackgroundResourceLocation();
        this.initGuiWidgets(guiRenderer, backgroundResourceLocation);
        List<Widget> widgets = ((BabelContainer)this.field_147002_h).field_75151_b.stream().filter(slot -> slot instanceof BabelSlot).map(slot -> new SlotGuiWidget(SlotGuiWidget.SlotType.DEFAULT, backgroundResourceLocation, guiRenderer, slot.field_75223_e, slot.field_75221_f)).collect(Collectors.toList());
        this.addWidgets(widgets);
    }

    public void initGuiWidgets(@Nonnull GuiRenderer renderer, @Nonnull ResourceLocation backgroundResourceLocation) {
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    protected ResourceLocation getBackgroundResourceLocation() {
        return BabelTextureLocations.GUI.GUI_BLANK;
    }

    public void addWidgets(Widget ... widgets) {
        for (Widget widget : widgets) {
            this.func_230480_a_(widget);
        }
    }

    public void addWidgets(List<Widget> widgets) {
        for (Widget widget : widgets) {
            this.func_230480_a_(widget);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.func_227860_a_();
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        ItemStack mouseHeldItemStack = InventoryUtil.getPlayerMouseHeldItemStack();
        if (mouseHeldItemStack.func_190926_b()) {
            // empty if block
        }
        matrixStack.func_227865_b_();
    }

    protected void func_230451_b_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        RenderUtil.resetColor();
        this.drawCenteredTitleText(matrixStack, RenderUtil.getDefaultTextColor());
        this.drawInventoryTextAt(matrixStack, 8.0f, this.field_147000_g - 96 + 2, RenderUtil.getDefaultTextColor());
        for (Widget widget : this.field_230710_m_) {
            if (!widget.func_231047_b_((double)mouseX, (double)mouseY)) continue;
            widget.func_230443_a_(matrixStack, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            break;
        }
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderUtil.resetColor();
        ResourceLocation resourceLocation = this.getBackgroundResourceLocation();
        RenderUtil.bindTexture(resourceLocation);
        int relX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int relY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, relX, relY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void drawTitleTextAt(@Nonnull MatrixStack matrixStack, float x, float y) {
        this.drawTitleTextAt(matrixStack, x, y, RenderUtil.getDefaultTextColor());
    }

    protected void drawTitleTextAt(@Nonnull MatrixStack matrixStack, float x, float y, int color) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_230704_d_.getString(), x, y, color);
    }

    protected void drawCenteredTitleText(@Nonnull MatrixStack matrixStack, int color) {
        String title = this.field_230704_d_.getString();
        this.field_230712_o_.func_238421_b_(matrixStack, title, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(title) / 2), 6.0f, color);
    }

    protected void drawInventoryTextAt(@Nonnull MatrixStack matrixStack, float x, float y) {
        this.drawInventoryTextAt(matrixStack, x, y, RenderUtil.getDefaultTextColor());
    }

    protected void drawInventoryTextAt(@Nonnull MatrixStack matrixStack, float x, float y, int color) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_213127_e.func_145748_c_().getString(), x, y, color);
    }
}

