/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core.container;

import com.thenatekirby.babel.Babel;
import com.thenatekirby.babel.api.ISyncable;
import com.thenatekirby.babel.core.inventory.ContainerInventory;
import com.thenatekirby.babel.core.slots.BabelSlot;
import com.thenatekirby.babel.core.slots.ItemSlot;
import com.thenatekirby.babel.core.tileentity.BabelTileEntity;
import com.thenatekirby.babel.mixin.ContainerMixin;
import com.thenatekirby.babel.network.packet.ContainerUpdateGuiPacket;
import com.thenatekirby.babel.network.sync.SyncableProgress;
import com.thenatekirby.babel.registration.DeferredContainer;
import com.thenatekirby.babel.util.ServerUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class BabelContainer
extends Container {
    private ContainerConfig containerConfig;
    private IItemHandler playerInventory;
    private World world;
    private ContainerInventory containerInventory;
    private BabelTileEntity tileEntity;
    private List<ISyncable> syncables;
    private PlayerEntity playerEntity;
    private SyncableProgress powerProgress;

    protected BabelContainer(@Nonnull ContainerConfig containerConfig, int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        super(containerConfig.getContainerType(), windowId);
        this.containerConfig = containerConfig;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.world = world;
        this.playerEntity = player;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof BabelTileEntity) {
            this.tileEntity = (BabelTileEntity)tileEntity;
            this.containerInventory = ((BabelTileEntity)tileEntity).getInventory();
        }
        this.initContainer();
        this.onPostInit();
    }

    public BabelTileEntity getTileEntity() {
        return this.tileEntity;
    }

    public ContainerInventory getContainerInventory() {
        return this.containerInventory;
    }

    protected List<IContainerListener> getContainerListeners() {
        return ((ContainerMixin)((Object)this)).getListeners();
    }

    protected List<ISyncable> getSyncables() {
        ArrayList<ISyncable> syncables = new ArrayList<ISyncable>();
        if (this.containerInventory != null && this.containerInventory.getEnergyStorage().getCapacity() > 0) {
            this.powerProgress = SyncableProgress.from(this.containerInventory.getEnergyStorage());
            syncables.add(this.powerProgress);
        }
        return syncables;
    }

    public SyncableProgress getPowerProgress() {
        return this.powerProgress;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        return true;
    }

    public void func_75142_b() {
        super.func_75142_b();
        ServerUtil.ifServer(this.tileEntity, world -> {
            PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
            for (ISyncable syncable : this.syncables) {
                syncable.write(packetBuffer);
            }
            ContainerUpdateGuiPacket packet = new ContainerUpdateGuiPacket(this.field_75152_c, packetBuffer);
            List<IContainerListener> listeners = this.getContainerListeners();
            for (IContainerListener listener : listeners) {
                if (!(listener instanceof ServerPlayerEntity)) continue;
                Babel.NETWORK.sendToPlayer((ServerPlayerEntity)listener, packet);
            }
        });
    }

    public void receive(ContainerUpdateGuiPacket packet) {
        PacketBuffer packetBuffer = packet.getBuffer();
        for (ISyncable syncable : this.syncables) {
            syncable.read(packetBuffer);
        }
    }

    protected void initContainer() {
    }

    protected void onPostInit() {
        if (this.tileEntity != null) {
            this.setupSlots();
            this.setupSyncedData();
        }
        this.onContainerOpen(this.playerEntity);
    }

    protected void onContainerOpen(PlayerEntity playerEntity) {
    }

    private void setupSlots() {
        this.layoutMachineSlots();
        this.layoutPlayerSlots();
    }

    private void setupSyncedData() {
        this.syncables = this.getSyncables();
    }

    private void layoutMachineSlots() {
        ContainerInventory inventory = this.getContainerInventory();
        if (this.tileEntity == null || inventory == null) {
            return;
        }
        for (ItemSlot itemSlot : inventory.getAllItemHandler().getAllSlots()) {
            this.func_75146_a(new BabelSlot(itemSlot));
        }
    }

    private void layoutPlayerSlots() {
        this.layoutPlayerInventorySlots(this.containerConfig.getPlayerInventoryStartX(), this.containerConfig.getPlayerInventoryStartY());
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack outputItemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        ContainerInventory containerInventory = this.getContainerInventory();
        if (containerInventory == null) {
            return ItemStack.field_190927_a;
        }
        if (slot != null && slot.func_75216_d()) {
            ItemStack inputItemStack = slot.func_75211_c();
            outputItemStack = inputItemStack.func_77946_l();
            int machineSlotCount = containerInventory.getSlotCount();
            int inventorySlotEnd = machineSlotCount + 36;
            if (index < machineSlotCount) {
                if (!this.func_75135_a(inputItemStack, machineSlotCount, inventorySlotEnd, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(inputItemStack, inputItemStack);
            } else if (containerInventory.canInsert(inputItemStack) ? !this.func_75135_a(inputItemStack, 0, machineSlotCount, false) : (index < machineSlotCount + 27 ? !this.func_75135_a(inputItemStack, machineSlotCount + 27, inventorySlotEnd, false) : index < inventorySlotEnd && !this.func_75135_a(inputItemStack, machineSlotCount, machineSlotCount + 27, false))) {
                return ItemStack.field_190927_a;
            }
            if (inputItemStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (inputItemStack.func_190916_E() == outputItemStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, inputItemStack);
        }
        return outputItemStack;
    }

    public static class ContainerConfig {
        @Nullable
        private ContainerType<?> containerType;
        private int playerInventoryStartX;
        private int playerInventoryStartY;
        public static ContainerConfig EMPTY = new ContainerConfig(null, 8, 84);

        private ContainerConfig(@Nullable ContainerType<?> containerType, int playerInventoryStartX, int playerInventoryStartY) {
            this.containerType = containerType;
            this.playerInventoryStartX = playerInventoryStartX;
            this.playerInventoryStartY = playerInventoryStartY;
        }

        public static ContainerConfig from(DeferredContainer<?> deferredContainer) {
            return new ContainerConfig(deferredContainer.getContainerType(), 8, 84);
        }

        public static ContainerConfig from(DeferredContainer<?> deferredContainer, int startX, int startY) {
            return new ContainerConfig(deferredContainer.getContainerType(), startX, startY);
        }

        @Nullable
        ContainerType<?> getContainerType() {
            return this.containerType;
        }

        public int getPlayerInventoryStartX() {
            return this.playerInventoryStartX;
        }

        public int getPlayerInventoryStartY() {
            return this.playerInventoryStartY;
        }
    }
}

