/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core.capability;

import com.thenatekirby.babel.api.IExperienceStorage;
import com.thenatekirby.babel.api.IProgress;
import com.thenatekirby.babel.core.capability.ExperienceBuffer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class ExperienceStorage
implements IExperienceStorage,
INBTSerializable<CompoundNBT>,
IProgress {
    private int capacity;
    private int current;
    private int maxExtract;
    private int maxReceive;
    private IExperienceStorageChangedObserver observer;

    public ExperienceStorage(int capacity, int current, int maxExtract, int maxReceive) {
        this.capacity = capacity;
        this.current = current;
        this.maxExtract = maxExtract;
        this.maxReceive = maxReceive;
    }

    public ExperienceStorage(@Nonnull ExperienceBuffer buffer) {
        this.capacity = buffer.capacity;
        this.current = buffer.current;
        this.maxExtract = buffer.maxExtract;
        this.maxReceive = buffer.maxReceive;
    }

    private void onExperienceChange() {
        if (this.observer != null) {
            this.observer.onExperienceChanged(this);
        }
    }

    public void setExperience(int current) {
        this.current = current;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int receiveExperience(int experience, boolean simulate) {
        int received = Math.min(this.capacity - this.current, Math.min(experience, this.maxReceive));
        if (!simulate) {
            this.current += received;
            this.onExperienceChange();
        }
        return received;
    }

    @Override
    public int extractExperience(int experience, boolean simulate) {
        int extracted = Math.min(this.current, Math.min(experience, this.maxExtract));
        if (!simulate) {
            this.current -= extracted;
            this.onExperienceChange();
        }
        return extracted;
    }

    @Override
    public int getExperienceStored() {
        return this.current;
    }

    @Override
    public int getMaxExperienceStored() {
        return this.capacity;
    }

    @Override
    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    @Override
    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("current", this.current);
        nbt.func_74768_a("capacity", this.capacity);
        nbt.func_74768_a("maxExtract", this.maxExtract);
        nbt.func_74768_a("maxReceive", this.maxReceive);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.current = nbt.func_74762_e("current");
        this.capacity = nbt.func_74762_e("capacity");
        this.maxExtract = nbt.func_74762_e("maxExtract");
        this.maxReceive = nbt.func_74762_e("maxReceive");
    }

    @Override
    public int getProgressMin() {
        return 0;
    }

    @Override
    public int getProgressMax() {
        return this.capacity;
    }

    @Override
    public int getProgressCurrent() {
        return this.current;
    }

    public static interface IExperienceStorageChangedObserver {
        public void onExperienceChanged(@Nonnull ExperienceStorage var1);
    }
}

