/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thenatekirby.babel.core.RecipeIngredient;
import com.thenatekirby.babel.mod.BabelSerializers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TaggedSmeltingRecipe
extends FurnaceRecipe {
    public static String RECIPE_TYPE_NAME = "smelting";
    private RecipeIngredient result;

    private TaggedSmeltingRecipe(ResourceLocation recipeId, String group, Ingredient input, RecipeIngredient result, float experience, int cookTime) {
        super(recipeId, group, input, ItemStack.field_190927_a, experience, cookTime);
        this.result = result;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return BabelSerializers.TAGGED_SMELTING.getAsRecipeSerializer();
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.result.makeItemStack();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TaggedSmeltingRecipe> {
        @Nonnull
        public TaggedSmeltingRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Ingredient input = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            int experience = JSONUtils.func_151203_m((JsonObject)json, (String)"experience");
            int cookingTime = JSONUtils.func_151203_m((JsonObject)json, (String)"cookingtime");
            JsonObject resultJson = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
            if (resultJson.has("tag")) {
                return new TaggedSmeltingRecipe(recipeId, group, input, RecipeIngredient.fromTag(JSONUtils.func_151200_h((JsonObject)resultJson, (String)"tag")), experience, cookingTime);
            }
            return new TaggedSmeltingRecipe(recipeId, group, input, RecipeIngredient.fromItem(JSONUtils.func_151200_h((JsonObject)resultJson, (String)"item")), experience, cookingTime);
        }

        @Nullable
        public TaggedSmeltingRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            String group = buffer.func_218666_n();
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            RecipeIngredient result = RecipeIngredient.read(buffer);
            float experience = buffer.readFloat();
            int cookTime = buffer.func_150792_a();
            return new TaggedSmeltingRecipe(recipeId, group, input, result, experience, cookTime);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull TaggedSmeltingRecipe recipe) {
            buffer.func_180714_a(recipe.field_222141_c);
            recipe.field_222142_d.func_199564_a(buffer);
            recipe.result.write(buffer);
            buffer.writeFloat(recipe.field_222144_f);
            buffer.func_150787_b(recipe.field_222145_g);
        }
    }
}

