/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.network.packet;

import com.thenatekirby.babel.api.IPacketHandler;
import com.thenatekirby.babel.core.container.BabelContainer;
import com.thenatekirby.babel.network.packet.BabelPacket;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ContainerUpdateGuiPacket
extends BabelPacket {
    private final int windowId;
    private final PacketBuffer buffer;

    public ContainerUpdateGuiPacket(int windowId, PacketBuffer buffer) {
        this.windowId = windowId;
        this.buffer = buffer;
    }

    public PacketBuffer getBuffer() {
        return this.buffer;
    }

    public static class Handler
    implements IPacketHandler<ContainerUpdateGuiPacket> {
        public static final Handler INSTANCE = new Handler();

        @Override
        public void encode(ContainerUpdateGuiPacket packet, PacketBuffer buffer) {
            buffer.writeInt(packet.windowId);
            buffer.writeBytes((ByteBuf)packet.buffer);
        }

        @Override
        public ContainerUpdateGuiPacket decode(PacketBuffer buffer) {
            int windowId = buffer.readInt();
            return new ContainerUpdateGuiPacket(windowId, buffer);
        }

        @Override
        public void handle(ContainerUpdateGuiPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
                if (playerEntity != null && playerEntity.field_71070_bA instanceof BabelContainer && playerEntity.field_71070_bA.field_75152_c == packet.windowId) {
                    ((BabelContainer)playerEntity.field_71070_bA).receive(packet);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

