/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.network;

import com.thenatekirby.babel.api.IPacketHandler;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkManager {
    private final ResourceLocation channelName;
    private final SimpleChannel channel;
    private int ID = 0;

    public NetworkManager(@Nonnull ResourceLocation channelName) {
        this.channelName = channelName;
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)channelName, () -> "1.0", val -> true, val -> true);
    }

    protected SimpleChannel getChannel() {
        return this.channel;
    }

    protected int nextID() {
        return this.ID++;
    }

    public <T> void register(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        this.getChannel().registerMessage(this.nextID(), messageType, encoder, decoder, messageConsumer);
    }

    public <T> void register(Class<T> messageType, IPacketHandler<T> packetHandler) {
        this.getChannel().registerMessage(this.nextID(), messageType, packetHandler::encode, packetHandler::decode, packetHandler::handle);
    }

    public <T> void sendToPlayer(ServerPlayerEntity entity, T packet) {
        this.getChannel().sendTo(packet, entity.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public <T> void sendToServer(T packet) {
        this.getChannel().sendToServer(packet);
    }
}

