/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.localization;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FormattedTranslationTextComponent {
    private final TranslationTextComponent base;
    private final Map<String, String> replacements = new HashMap<String, String>();

    public FormattedTranslationTextComponent(@Nonnull String translationKey) {
        this.base = new TranslationTextComponent(translationKey);
    }

    public FormattedTranslationTextComponent withReplacement(@Nonnull String key, @Nonnull String value) {
        this.replacements.put(key, value);
        return this;
    }

    public StringTextComponent makeTextComponent() {
        String rawValue = this.base.getString();
        for (Map.Entry<String, String> replacement : this.replacements.entrySet()) {
            rawValue = rawValue.replace("{{" + replacement.getKey() + "}}", replacement.getValue());
        }
        return new StringTextComponent(rawValue);
    }
}

