/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.integration.botanypots;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thenatekirby.babel.condition.IRecipeCondition;
import com.thenatekirby.babel.condition.ModLoadedCondition;
import com.thenatekirby.babel.integration.Mods;
import com.thenatekirby.babel.recipe.IExternalRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class BotanyPotsCropRecipeBuilder {
    private final ResourceLocation recipeId;
    private String seed;
    private List<String> categories = new ArrayList<String>();
    private int growthTicks;
    private String displayBlock;
    private String output;
    private float chance;
    private List<JsonObject> conditions = new ArrayList<JsonObject>();

    private BotanyPotsCropRecipeBuilder(@Nonnull ResourceLocation recipeId) {
        this.recipeId = recipeId;
        this.conditions.add(new ModLoadedCondition("botanypots").serializeJson());
    }

    public static BotanyPotsCropRecipeBuilder builder(@Nonnull ResourceLocation recipeId) {
        return new BotanyPotsCropRecipeBuilder(recipeId);
    }

    public BotanyPotsCropRecipeBuilder withSeed(@Nonnull String seed) {
        this.seed = seed;
        return this;
    }

    public BotanyPotsCropRecipeBuilder withCategory(@Nonnull String category) {
        this.categories.add(category);
        return this;
    }

    public BotanyPotsCropRecipeBuilder withGrowthTicks(int growthTicks) {
        this.growthTicks = growthTicks;
        return this;
    }

    public BotanyPotsCropRecipeBuilder withDisplayBlock(@Nonnull String displayBlock) {
        this.displayBlock = displayBlock;
        return this;
    }

    public BotanyPotsCropRecipeBuilder withOutput(@Nonnull String id) {
        this.output = id;
        return this;
    }

    public BotanyPotsCropRecipeBuilder withChance(float chance) {
        this.chance = chance;
        return this;
    }

    public BotanyPotsCropRecipeBuilder withCondition(@Nonnull IRecipeCondition condition) {
        this.conditions.add(condition.serializeJson());
        return this;
    }

    public void build(Consumer<IExternalRecipe> consumer) {
        consumer.accept(new Result(this.recipeId, this.seed, this.categories, this.growthTicks, this.displayBlock, this.output, this.chance, this.conditions));
    }

    public static class Result
    implements IExternalRecipe {
        private final ResourceLocation recipeId;
        private final String seedId;
        private final List<String> categories;
        private final int growthTicks;
        private final String displayBlock;
        private final String output;
        private final float chance;
        private final List<JsonObject> conditions;

        Result(@Nonnull ResourceLocation recipeId, @Nonnull String seedId, @Nonnull List<String> categories, int growthTicks, @Nonnull String displayBlock, @Nonnull String output, float chance, @Nonnull List<JsonObject> conditions) {
            this.recipeId = recipeId;
            this.seedId = seedId;
            this.categories = categories;
            this.growthTicks = growthTicks;
            this.displayBlock = displayBlock;
            this.output = output;
            this.chance = chance;
            this.conditions = conditions;
        }

        @Override
        public void serialize(@Nonnull JsonObject json) {
            if (!this.conditions.isEmpty()) {
                JsonArray conditions = new JsonArray();
                for (JsonObject jsonObject : this.conditions) {
                    conditions.add((JsonElement)jsonObject);
                }
                json.add("conditions", (JsonElement)conditions);
            }
            JsonObject seedJson = new JsonObject();
            seedJson.addProperty("item", this.seedId);
            json.add("seed", (JsonElement)seedJson);
            JsonArray categoriesJson = new JsonArray();
            for (String category : this.categories) {
                categoriesJson.add(category);
            }
            json.add("categories", (JsonElement)categoriesJson);
            json.addProperty("growthTicks", (Number)this.growthTicks);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("block", this.displayBlock);
            JsonObject propsJson = new JsonObject();
            propsJson.addProperty("age", (Number)3);
            jsonObject.add("properties", (JsonElement)propsJson);
            json.add("display", (JsonElement)jsonObject);
            JsonArray resultsJson = new JsonArray();
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("chance", (Number)Float.valueOf(this.chance));
            JsonObject outputJson = new JsonObject();
            outputJson.addProperty("item", this.output);
            resultJson.add("output", (JsonElement)outputJson);
            resultJson.addProperty("minRolls", (Number)1);
            resultJson.addProperty("maxRolls", (Number)1);
            resultsJson.add((JsonElement)resultJson);
            json.add("results", (JsonElement)resultsJson);
        }

        @Override
        @Nonnull
        public ResourceLocation getId() {
            return this.recipeId;
        }

        @Override
        @Nonnull
        public ResourceLocation getType() {
            return Mods.BOTANY_POTS.withPath("crop");
        }
    }
}

