/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core.inventory;

import com.thenatekirby.babel.core.inventory.ContainerInventory;
import com.thenatekirby.babel.core.slots.ItemSlot;
import com.thenatekirby.babel.util.ItemStackUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.IItemHandler;

public class InventoryItemHandler
implements IItemHandler {
    @Nonnull
    private final ContainerInventory inventory;
    @Nonnull
    private final List<ItemSlot> inputSlots;
    @Nonnull
    private final List<ItemSlot> outputSlots;
    @Nonnull
    private final List<ItemSlot> auxiliarySlots;
    @Nonnull
    private final List<ItemSlot> allSlots = new ArrayList<ItemSlot>();

    public InventoryItemHandler(@Nonnull ContainerInventory inventory, @Nonnull List<ItemSlot> inputSlots, @Nonnull List<ItemSlot> outputSlots, @Nonnull List<ItemSlot> auxiliarySlots) {
        this.inventory = inventory;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.auxiliarySlots = auxiliarySlots;
        this.allSlots.addAll(inputSlots);
        this.allSlots.addAll(outputSlots);
        this.allSlots.addAll(auxiliarySlots);
    }

    public int getSlots() {
        return this.allSlots.size();
    }

    public ItemSlot getSlot(int slot) {
        return this.allSlots.get(slot);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.getSlot(slot).getItemStack();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int inputSlotCount = this.inputSlots.size();
        if (slot < 0 || slot > inputSlotCount) {
            return stack;
        }
        ItemStack insertStack = ItemStackUtil.itemStackWithSize(stack, stack.func_190916_E());
        for (ItemSlot itemSlot : this.inputSlots) {
            insertStack = itemSlot.insertItem(0, insertStack, simulate);
            if (!insertStack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return insertStack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int inputSlotCount = this.inputSlots.size();
        if (slot < inputSlotCount || slot > this.getSlots()) {
            return ItemStack.field_190927_a;
        }
        return this.allSlots.get(slot).extractItem(0, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.getSlot(slot).getSlotLimit(0);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.getSlot(slot).isItemValid(0, stack);
    }

    @Nonnull
    public List<ItemSlot> getInputSlots() {
        return this.inputSlots;
    }

    @Nonnull
    public List<ItemSlot> getOutputSlots() {
        return this.outputSlots;
    }

    @Nonnull
    public List<ItemSlot> getAuxiliarySlots() {
        return this.auxiliarySlots;
    }

    @Nonnull
    public List<ItemSlot> getAllSlots() {
        return this.allSlots;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT listNBT = new ListNBT();
        for (ItemSlot slot : this.allSlots) {
            listNBT.add((Object)slot.serializeNBT());
        }
        nbt.func_218657_a("slots", (INBT)listNBT);
        return nbt;
    }

    public void deserializeNBT(@Nonnull CompoundNBT nbt) {
        ListNBT listNBT = nbt.func_150295_c("slots", 10);
        for (int idx = 0; idx < listNBT.size(); ++idx) {
            CompoundNBT slotNBT = listNBT.func_150305_b(idx);
            this.allSlots.get(idx).deserializeNBT(slotNBT);
        }
    }
}

