/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.datagen.data.recipes.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SimpleShapelessRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private String subDirectory = null;

    public SimpleShapelessRecipeBuilder(IItemProvider result, int count) {
        this.result = result.func_199767_j();
        this.count = count;
    }

    public static SimpleShapelessRecipeBuilder shapelessRecipe(IItemProvider result) {
        return SimpleShapelessRecipeBuilder.shapelessRecipe(result, 1);
    }

    public static SimpleShapelessRecipeBuilder shapelessRecipe(IItemProvider result, int count) {
        return new SimpleShapelessRecipeBuilder(result, count);
    }

    public SimpleShapelessRecipeBuilder addIngredient(ITag<Item> tagIn) {
        return this.addIngredient(Ingredient.func_199805_a(tagIn));
    }

    public SimpleShapelessRecipeBuilder addIngredient(IItemProvider itemIn) {
        return this.addIngredient(itemIn, 1);
    }

    public SimpleShapelessRecipeBuilder addIngredient(IItemProvider itemIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
        }
        return this;
    }

    public SimpleShapelessRecipeBuilder addIngredient(Ingredient ingredientIn) {
        return this.addIngredient(ingredientIn, 1);
    }

    public SimpleShapelessRecipeBuilder addIngredient(Ingredient ingredientIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredientIn);
        }
        return this;
    }

    public SimpleShapelessRecipeBuilder subDirectory(String dir) {
        this.subDirectory = dir;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result.getItem()));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        String path = id.func_110623_a();
        if (this.subDirectory != null && !this.subDirectory.isEmpty()) {
            path = this.subDirectory + "/" + path;
        }
        id = new ResourceLocation(id.func_110624_b(), "shapeless/" + path);
        consumerIn.accept(new Result(id, this.result, this.count, this.ingredients));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation key;
        private final Item result;
        private final int count;
        private final List<Ingredient> ingredients;

        public Result(ResourceLocation key, Item result, int resultCount, List<Ingredient> ingredients) {
            this.key = key;
            this.result = result;
            this.count = resultCount;
            this.ingredients = ingredients;
        }

        public void func_218610_a(JsonObject json) {
            JsonArray inputs = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                inputs.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)inputs);
            JsonObject result = new JsonObject();
            result.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
            if (this.count > 1) {
                result.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)result);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222158_b;
        }

        public ResourceLocation func_200442_b() {
            return this.key;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return new ResourceLocation("");
        }
    }
}

