/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world;

import hellfirepvp.astralsorcery.common.world.marker.MarkerManagerAS;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class TemplateStructure
extends TemplateStructurePiece {
    private int yOffset = 0;

    public TemplateStructure(IStructurePieceType structurePieceTypeIn, TemplateManager mgr, BlockPos templatePosition) {
        super(structurePieceTypeIn, 0);
        this.field_186178_c = templatePosition;
        this.loadTemplate(mgr);
    }

    public TemplateStructure(IStructurePieceType structurePieceTypeIn, TemplateManager mgr, CompoundNBT nbt) {
        super(structurePieceTypeIn, nbt);
        this.loadTemplate(mgr);
    }

    private void loadTemplate(TemplateManager mgr) {
        Template tpl = mgr.func_200220_a(this.getStructureName());
        PlacementSettings settings = new PlacementSettings().func_186222_a(true).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        this.func_186173_a(tpl, this.field_186178_c, settings);
    }

    public <T extends TemplateStructure> T setYOffset(int yOffset) {
        this.yOffset = yOffset;
        return (T)((Object)this);
    }

    public abstract ResourceLocation getStructureName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_230383_a_(ISeedReader world, StructureManager mgr, ChunkGenerator gen, Random rand, MutableBoundingBox box, ChunkPos chunkPos, BlockPos structCenter) {
        MutableBoundingBox genBox = new MutableBoundingBox(box);
        genBox.func_78886_a(0, this.yOffset, 0);
        BlockPos original = this.field_186178_c;
        this.field_186178_c = original.func_177981_b(this.yOffset);
        try {
            boolean bl = super.func_230383_a_(world, mgr, gen, rand, genBox, chunkPos, structCenter.func_177981_b(this.yOffset));
            return bl;
        }
        finally {
            this.field_186178_c = original;
            this.field_186177_b.func_186223_a(box);
            this.field_74887_e = this.field_186176_a.func_215388_b(this.field_186177_b, this.field_186178_c);
        }
    }

    protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
        if (sbb.func_175898_b((Vector3i)pos)) {
            MarkerManagerAS.handleMarker(function, pos, (IWorld)worldIn, rand, this.field_74887_e);
        }
    }
}

