/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type.vanilla;

import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSource;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.perk.type.vanilla.VanillaPerkAttributeType;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;

public abstract class VanillaAttributeType
extends PerkAttributeType
implements VanillaPerkAttributeType {
    public VanillaAttributeType(ResourceLocation name) {
        super(name);
    }

    @Override
    public void onApply(PlayerEntity player, LogicalSide side, ModifierSource source) {
        super.onApply(player, side, source);
        this.refreshAttribute(player);
    }

    @Override
    public void onRemove(PlayerEntity player, LogicalSide side, boolean removedCompletely, ModifierSource source) {
        super.onRemove(player, side, removedCompletely, source);
        this.refreshAttribute(player);
    }

    @Override
    public void onModeApply(PlayerEntity player, ModifierType mode, LogicalSide side) {
        AttributeModifier modifier;
        super.onModeApply(player, mode, side);
        ModifiableAttributeInstance attr = player.func_233645_dx_().func_233779_a_(this.getAttribute());
        if (attr == null) {
            return;
        }
        if (side.isClient() && (modifier = attr.func_111127_a(this.getID(mode))) != null) {
            if (!(modifier instanceof DynamicAttributeModifier)) {
                attr.func_188479_b(this.getID(mode));
            } else {
                return;
            }
        }
        switch (mode) {
            case ADDITION: {
                attr.func_233767_b_((AttributeModifier)new DynamicAttributeModifier(this.getID(mode), this.getDescription() + " Add", (PerkAttributeType)this, mode, player, side));
                break;
            }
            case ADDED_MULTIPLY: {
                attr.func_233767_b_((AttributeModifier)new DynamicAttributeModifier(this.getID(mode), this.getDescription() + " Multiply Add", (PerkAttributeType)this, mode, player, side));
                break;
            }
            case STACKING_MULTIPLY: {
                attr.func_233767_b_((AttributeModifier)new DynamicAttributeModifier(this.getID(mode), this.getDescription() + " Stack Add", (PerkAttributeType)this, mode, player, side));
                break;
            }
        }
    }

    @Override
    public void onModeRemove(PlayerEntity player, ModifierType mode, LogicalSide side, boolean removedCompletely) {
        super.onModeRemove(player, mode, side, removedCompletely);
        ModifiableAttributeInstance attr = player.func_233645_dx_().func_233779_a_(this.getAttribute());
        if (attr == null) {
            return;
        }
        attr.func_188479_b(this.getID(mode));
    }

    @Override
    public void refreshAttribute(PlayerEntity player) {
        ModifiableAttributeInstance attr = player.func_233645_dx_().func_233779_a_(this.getAttribute());
        if (attr == null) {
            return;
        }
        double base = attr.func_111125_b();
        if (base == 0.0) {
            attr.func_111128_a(1.0);
        } else {
            attr.func_111128_a(0.0);
        }
        attr.func_111128_a(base);
    }

    public abstract UUID getID(ModifierType var1);

    public abstract String getDescription();

    @Override
    @Nonnull
    public abstract Attribute getAttribute();

    static class DynamicAttributeModifier
    extends AttributeModifier {
        private PlayerEntity player;
        private LogicalSide side;
        private PerkAttributeType type;

        public DynamicAttributeModifier(UUID idIn, String nameIn, PerkAttributeType type, ModifierType mode, PlayerEntity player, LogicalSide side) {
            this(idIn, nameIn, type, mode.getVanillaAttributeOperation(), player, side);
        }

        public DynamicAttributeModifier(UUID idIn, String nameIn, PerkAttributeType type, AttributeModifier.Operation operationIn, PlayerEntity player, LogicalSide side) {
            super(idIn, nameIn, operationIn == AttributeModifier.Operation.MULTIPLY_TOTAL ? 1.0 : 0.0, operationIn);
            this.player = player;
            this.side = side;
            this.type = type;
        }

        public double func_111164_d() {
            ModifierType mode = ModifierType.fromVanillaAttributeOperation(this.func_220375_c());
            return PerkAttributeHelper.getOrCreateMap(this.player, this.side).getModifier(this.player, ResearchHelper.getProgress(this.player, this.side), this.type, mode) - 1.0f;
        }
    }
}

