/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.source;

import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktSyncModifierSource;
import hellfirepvp.astralsorcery.common.perk.PerkEffectHelper;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSource;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;

public abstract class ModifierSourceProvider<T extends ModifierSource> {
    private final ResourceLocation key;
    private final Map<UUID, Map<ResourceLocation, T>> cachedSources = new HashMap<UUID, Map<ResourceLocation, T>>();

    protected ModifierSourceProvider(ResourceLocation key) {
        this.key = key;
    }

    protected abstract void update(ServerPlayerEntity var1);

    protected abstract void removeModifiers(ServerPlayerEntity var1);

    public abstract void serialize(T var1, PacketBuffer var2);

    public abstract T deserialize(PacketBuffer var1);

    @Nullable
    private T getModifier(ServerPlayerEntity player, ResourceLocation identifier) {
        Map playerModifiers = this.cachedSources.computeIfAbsent(player.func_110124_au(), uuid -> new HashMap());
        return (T)((ModifierSource)playerModifiers.get(identifier));
    }

    private void setModifier(ServerPlayerEntity player, ResourceLocation identifier, @Nullable T source) {
        Map playerModifiers = this.cachedSources.computeIfAbsent(player.func_110124_au(), uuid -> new HashMap());
        if (source != null) {
            playerModifiers.put(identifier, source);
        } else {
            playerModifiers.remove(identifier);
        }
    }

    protected void updateSource(ServerPlayerEntity player, ResourceLocation identifier, @Nullable T source) {
        boolean needsRemoval = false;
        boolean needsAddition = false;
        T existing = this.getModifier(player, identifier);
        if (existing != null) {
            if (!existing.isEqual((ModifierSource)source)) {
                needsRemoval = true;
            } else {
                return;
            }
        }
        if (source != null) {
            needsAddition = true;
        }
        if (needsRemoval) {
            if (needsAddition) {
                PerkEffectHelper.updateSource((PlayerEntity)player, LogicalSide.SERVER, existing, source);
                PacketChannel.CHANNEL.sendToPlayer((PlayerEntity)player, PktSyncModifierSource.update(existing, source));
            } else {
                PerkEffectHelper.modifySource((PlayerEntity)player, LogicalSide.SERVER, existing, PerkEffectHelper.Action.REMOVE);
                PacketChannel.CHANNEL.sendToPlayer((PlayerEntity)player, PktSyncModifierSource.remove(existing));
            }
        } else if (needsAddition) {
            PerkEffectHelper.modifySource((PlayerEntity)player, LogicalSide.SERVER, source, PerkEffectHelper.Action.ADD);
            PacketChannel.CHANNEL.sendToPlayer((PlayerEntity)player, PktSyncModifierSource.add(source));
        }
        this.setModifier(player, identifier, source);
    }

    public final ResourceLocation getKey() {
        return this.key;
    }
}

