/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.auxiliary.CropHelper;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import hellfirepvp.astralsorcery.common.perk.tick.PlayerTickPerk;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.LogicalSide;

public class KeyGrowables
extends KeyPerk
implements PlayerTickPerk {
    private static final float defaultChanceToBonemeal = 0.3f;
    private static final int defaultRadius = 3;
    private static final int defaultChargeCost = 120;
    public static final Config CONFIG = new Config("key.growable");

    public KeyGrowables(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void onPlayerTick(PlayerEntity player, LogicalSide side) {
        if (!side.isServer()) {
            return;
        }
        PlayerProgress prog = ResearchHelper.getProgress(player, side);
        float cChance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, ((Double)CONFIG.chanceToBonemeal.get()).floatValue());
        if (rand.nextFloat() < cChance && AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), true)) {
            float fRadius = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, ((Integer)CONFIG.radius.get()).intValue());
            int rRadius = Math.max(MathHelper.func_76141_d((float)fRadius), 1);
            BlockPos pos = player.func_233580_cy_().func_177982_a(rand.nextInt(rRadius * 2) + 1 - rRadius, rand.nextInt(rRadius * 2) + 1 - rRadius, rand.nextInt(rRadius * 2) + 1 - rRadius);
            World w = player.func_130014_f_();
            CropHelper.GrowablePlant plant = CropHelper.wrapPlant((IWorld)w, pos);
            PktPlayEffect pkt = null;
            if (plant != null) {
                if (plant.tryGrow((IWorld)w, rand)) {
                    AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), false);
                    pkt = new PktPlayEffect(PktPlayEffect.Type.CROP_GROWTH).addData(buf -> ByteBufUtils.writeVector(buf, new Vector3((Vector3i)pos)));
                }
            } else {
                BlockState at = w.func_180495_p(pos);
                if (at.func_177230_c().equals(Blocks.field_150346_d) && w.func_175623_d(pos.func_177984_a()) && w.func_175656_a(pos, Blocks.field_196658_i.func_176223_P())) {
                    AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), false);
                    pkt = new PktPlayEffect(PktPlayEffect.Type.CROP_GROWTH).addData(buf -> ByteBufUtils.writeVector(buf, new Vector3((Vector3i)pos)));
                }
            }
            if (pkt != null) {
                PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos(w, (Vector3i)pos, 16.0));
            }
        }
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.DoubleValue chanceToBonemeal;
        private ForgeConfigSpec.IntValue radius;
        private ForgeConfigSpec.IntValue chargeCost;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.chanceToBonemeal = cfgBuilder.comment("Sets the chance to try to see if a random plant near the player gets bonemeal'd.").translation(this.translationKey("chanceToBonemeal")).defineInRange("chanceToBonemeal", (double)0.3f, 0.0, 1.0);
            this.radius = cfgBuilder.comment("Defines the radius around which the perk effect should apply around the player.").translation(this.translationKey("radius")).defineInRange("radius", 3, 1, 16);
            this.chargeCost = cfgBuilder.comment("Defines the amount of starlight charge consumed per growth-attempt.").translation(this.translationKey("chargeCost")).defineInRange("chargeCost", 120, 1, 500);
        }
    }
}

