/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantment;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantmentType;
import hellfirepvp.astralsorcery.common.event.DynamicEnchantmentEvent;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class KeyAddEnchantment
extends KeyPerk {
    private final List<DynamicEnchantment> enchantments = Lists.newArrayList();

    public KeyAddEnchantment(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        if (side.isServer()) {
            bus.addListener(this::onEnchantmentAddServer);
        } else {
            bus.addListener(this::onEnchantmentAddClient);
        }
    }

    public KeyAddEnchantment addEnchantment(Enchantment ench, int level) {
        return this.addEnchantment(DynamicEnchantmentType.ADD_TO_SPECIFIC, ench, level);
    }

    public KeyAddEnchantment addEnchantment(DynamicEnchantmentType type, Enchantment ench, int level) {
        this.enchantments.add(new DynamicEnchantment(type, ench, level));
        return this;
    }

    public KeyAddEnchantment addAllEnchantmentIncrease(int level) {
        this.enchantments.add(new DynamicEnchantment(DynamicEnchantmentType.ADD_TO_EXISTING_ALL, level));
        return this;
    }

    private void onEnchantmentAddClient(DynamicEnchantmentEvent.Add event) {
        PlayerEntity player = event.getResolvedPlayer();
        LogicalSide side = this.getSide((Entity)player);
        if (side.isClient()) {
            this.addEnchantments(player, side, event);
        }
    }

    private void onEnchantmentAddServer(DynamicEnchantmentEvent.Add event) {
        PlayerEntity player = event.getResolvedPlayer();
        LogicalSide side = this.getSide((Entity)player);
        if (side.isServer()) {
            this.addEnchantments(player, side, event);
        }
    }

    private void addEnchantments(PlayerEntity player, LogicalSide side, DynamicEnchantmentEvent.Add event) {
        PlayerProgress prog = ResearchHelper.getProgress(player, side);
        if (prog.getPerkData().hasPerkEffect(this)) {
            List<DynamicEnchantment> listedEnchantments = event.getEnchantmentsToApply();
            for (DynamicEnchantment ench : this.enchantments) {
                DynamicEnchantment added = MiscUtils.iterativeSearch(listedEnchantments, e -> (e.getEnchantment() == null ? ench.getEnchantment() == null : e.getEnchantment().equals(ench.getEnchantment())) && e.getType().equals((Object)ench.getType()));
                if (added != null) {
                    added.setLevelAddition(added.getLevelAddition() + ench.getLevelAddition());
                    continue;
                }
                listedEnchantments.add(ench.copy());
            }
        }
    }

    @Override
    public void deserializeData(JsonObject perkData) {
        super.deserializeData(perkData);
        this.enchantments.clear();
        if (perkData.has("enchantments")) {
            JsonArray array = JSONUtils.func_151214_t((JsonObject)perkData, (String)"enchantments");
            for (int i = 0; i < array.size(); ++i) {
                DynamicEnchantmentType type;
                JsonObject serializedEnchantment = JSONUtils.func_151210_l((JsonElement)array.get(i), (String)"enchantments[%s]");
                String typeKey = JSONUtils.func_151200_h((JsonObject)serializedEnchantment, (String)"type");
                try {
                    type = DynamicEnchantmentType.valueOf(typeKey);
                }
                catch (Exception exc) {
                    throw new IllegalArgumentException("Unknown dynamic enchantment type: " + typeKey);
                }
                int level = JSONUtils.func_151203_m((JsonObject)serializedEnchantment, (String)"level");
                if (type.isEnchantmentSpecific()) {
                    String enchantmentKey = JSONUtils.func_151200_h((JsonObject)serializedEnchantment, (String)"enchantment");
                    Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantmentKey));
                    if (ench == null) {
                        throw new IllegalArgumentException("Unknown Enchantment: " + enchantmentKey);
                    }
                    this.addEnchantment(type, ench, level);
                    continue;
                }
                this.addAllEnchantmentIncrease(level);
            }
        }
    }

    @Override
    public void serializeData(JsonObject perkData) {
        super.serializeData(perkData);
        if (!this.enchantments.isEmpty()) {
            JsonArray array = new JsonArray();
            for (DynamicEnchantment enchantment : this.enchantments) {
                JsonObject serializedEnchantment = new JsonObject();
                serializedEnchantment.addProperty("type", enchantment.getType().name());
                if (enchantment.getEnchantment() != null) {
                    serializedEnchantment.addProperty("enchantment", enchantment.getEnchantment().getRegistryName().toString());
                }
                serializedEnchantment.addProperty("level", (Number)enchantment.getLevelAddition());
                array.add((JsonElement)serializedEnchantment);
            }
            perkData.add("enchantments", (JsonElement)array);
        }
    }
}

