/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import hellfirepvp.astralsorcery.common.data.sync.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientData;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktSyncData
extends ASPacket<PktSyncData> {
    private Map<ResourceLocation, CompoundNBT> diffData = new HashMap<ResourceLocation, CompoundNBT>();

    public PktSyncData() {
    }

    public PktSyncData(Map<ResourceLocation, CompoundNBT> dataToSend) {
        this.diffData = dataToSend;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktSyncData> encoder() {
        return (packet, buffer) -> {
            buffer.writeInt(packet.diffData.size());
            for (ResourceLocation key : packet.diffData.keySet()) {
                ByteBufUtils.writeResourceLocation(buffer, key);
                ByteBufUtils.writeNBTTag(buffer, packet.diffData.get(key));
            }
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktSyncData> decoder() {
        return buffer -> {
            PktSyncData pktData = new PktSyncData();
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                ResourceLocation key = ByteBufUtils.readResourceLocation(buffer);
                CompoundNBT tag = ByteBufUtils.readNBTTag(buffer);
                pktData.diffData.put(key, tag);
            }
            return pktData;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktSyncData> handler() {
        return new ASPacket.Handler<PktSyncData>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktSyncData packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    for (ResourceLocation key : packet.diffData.keySet()) {
                        ClientDataReader reader = SyncDataHolder.getReader(key);
                        if (reader == null) continue;
                        SyncDataHolder.executeClient(key, ClientData.class, data -> reader.readFromIncomingDiff(data, (CompoundNBT)packet.diffData.get(key)));
                    }
                });
            }

            @Override
            public void handle(PktSyncData packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

