/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktProgressionUpdate;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class ItemKnowledgeShare
extends Item {
    public ItemKnowledgeShare() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CommonProxy.ITEM_GROUP_AS));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack creative = new ItemStack((IItemProvider)this);
            this.setCreative(creative);
            items.add((Object)creative);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (ItemKnowledgeShare.isCreative(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("astralsorcery.misc.knowledge.inscribed.creative").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            return;
        }
        if (ItemKnowledgeShare.getKnowledge(stack) == null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("astralsorcery.misc.knowledge.missing").func_240699_a_(TextFormatting.GRAY));
        } else {
            IFormattableTextComponent name = ItemKnowledgeShare.getKnowledgeOwnerName(stack);
            if (name != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("astralsorcery.misc.knowledge.inscribed", new Object[]{name}).func_240699_a_(TextFormatting.BLUE));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_190926_b() || world.func_201670_d() || !(held.func_77973_b() instanceof ItemKnowledgeShare)) {
            return ActionResult.func_226248_a_((Object)held);
        }
        if (!ItemKnowledgeShare.isCreative(held) && (player.func_225608_bj_() || ItemKnowledgeShare.getKnowledge(held) == null)) {
            this.tryInscribeKnowledge(held, player);
        } else {
            this.tryGiveKnowledge(held, player);
        }
        return ActionResult.func_226248_a_((Object)held);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        if (stack.func_190926_b() || player == null || context.func_195991_k().func_201670_d() || !(stack.func_77973_b() instanceof ItemKnowledgeShare)) {
            return ActionResultType.SUCCESS;
        }
        if (!ItemKnowledgeShare.isCreative(stack) && (player.func_225608_bj_() || ItemKnowledgeShare.getKnowledge(stack) == null)) {
            this.tryInscribeKnowledge(stack, player);
        } else {
            this.tryGiveKnowledge(stack, player);
        }
        return ActionResultType.SUCCESS;
    }

    private void tryGiveKnowledge(ItemStack stack, PlayerEntity player) {
        if (player instanceof ServerPlayerEntity && MiscUtils.isPlayerFakeMP((ServerPlayerEntity)player)) {
            return;
        }
        if (ItemKnowledgeShare.isCreative(stack)) {
            ResearchManager.forceMaximizeAll(player);
            return;
        }
        if (ItemKnowledgeShare.canInscribeKnowledge(stack, player)) {
            return;
        }
        PlayerProgress progress = ItemKnowledgeShare.getKnowledge(stack);
        if (progress == null) {
            return;
        }
        ProgressionTier prev = progress.getTierReached();
        if (ResearchHelper.mergeApplyPlayerprogress(progress, player) && progress.getTierReached().isThisLater(prev)) {
            PktProgressionUpdate pkt = new PktProgressionUpdate(progress.getTierReached());
            PacketChannel.CHANNEL.sendToPlayer(player, pkt);
        }
    }

    private void tryInscribeKnowledge(ItemStack stack, PlayerEntity player) {
        if (ItemKnowledgeShare.canInscribeKnowledge(stack, player)) {
            ItemKnowledgeShare.setKnowledge(stack, player, ResearchHelper.getProgress(player, LogicalSide.SERVER));
        }
    }

    @Nullable
    public static PlayerEntity getKnowledgeOwner(ItemStack stack, MinecraftServer server) {
        if (ItemKnowledgeShare.isCreative(stack)) {
            return null;
        }
        CompoundNBT compound = NBTHelper.getPersistentData(stack);
        UUID owner = NBTHelper.getUUID(compound, "knowledgeOwnerUUID", null);
        if (owner == null) {
            return null;
        }
        return server.func_184103_al().func_177451_a(owner);
    }

    @Nullable
    public static IFormattableTextComponent getKnowledgeOwnerName(ItemStack stack) {
        if (ItemKnowledgeShare.isCreative(stack)) {
            return null;
        }
        CompoundNBT compound = NBTHelper.getPersistentData(stack);
        if (!compound.func_74764_b("knowledgeOwnerName")) {
            return null;
        }
        return ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("knowledgeOwnerName"));
    }

    @Nullable
    public static PlayerProgress getKnowledge(ItemStack stack) {
        if (ItemKnowledgeShare.isCreative(stack)) {
            return null;
        }
        CompoundNBT compound = NBTHelper.getPersistentData(stack);
        if (!compound.func_74764_b("knowledgeTag")) {
            return null;
        }
        CompoundNBT tag = compound.func_74775_l("knowledgeTag");
        try {
            PlayerProgress progress = new PlayerProgress();
            progress.loadKnowledge(tag);
            return progress;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static boolean canInscribeKnowledge(ItemStack stack, PlayerEntity player) {
        if (ItemKnowledgeShare.isCreative(stack)) {
            return false;
        }
        CompoundNBT compound = NBTHelper.getPersistentData(stack);
        UUID owner = NBTHelper.getUUID(compound, "knowledgeOwnerUUID", null);
        if (owner == null) {
            return true;
        }
        return player.func_110124_au().equals(owner);
    }

    public static void setKnowledge(ItemStack stack, PlayerEntity player, PlayerProgress progress) {
        if (ItemKnowledgeShare.isCreative(stack) || !progress.isValid()) {
            return;
        }
        CompoundNBT knowledge = new CompoundNBT();
        progress.storeKnowledge(knowledge);
        CompoundNBT compound = NBTHelper.getPersistentData(stack);
        compound.func_74778_a("knowledgeOwnerName", ITextComponent.Serializer.func_150696_a((ITextComponent)player.func_145748_c_()));
        compound.func_186854_a("knowledgeOwnerUUID", player.func_110124_au());
        compound.func_218657_a("knowledgeTag", (INBT)knowledge);
    }

    public static boolean isCreative(ItemStack stack) {
        CompoundNBT cmp = NBTHelper.getPersistentData(stack);
        if (!cmp.func_74764_b("creativeKnowledge")) {
            return false;
        }
        return cmp.func_74767_n("creativeKnowledge");
    }

    private void setCreative(ItemStack stack) {
        NBTHelper.getPersistentData(stack).func_74757_a("creativeKnowledge", true);
    }
}

