/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry.sets;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataSet;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class PerkAttributeEntry
implements ConfigDataSet {
    private final PerkAttributeType type;
    private final int weight;

    public PerkAttributeEntry(PerkAttributeType type, int weight) {
        this.type = type;
        this.weight = weight;
    }

    public PerkAttributeType getType() {
        return this.type;
    }

    public int getWeight() {
        return this.weight;
    }

    @Nullable
    public static PerkAttributeEntry deserialize(String str) {
        int weight;
        String[] split = str.split(";");
        if (split.length != 2) {
            return null;
        }
        ResourceLocation keyAttributeType = new ResourceLocation(split[0]);
        PerkAttributeType type = (PerkAttributeType)RegistriesAS.REGISTRY_PERK_ATTRIBUTE_TYPES.getValue(keyAttributeType);
        if (type == null) {
            return null;
        }
        String strWeight = split[1];
        try {
            weight = Integer.parseInt(strWeight);
        }
        catch (NumberFormatException exc) {
            return null;
        }
        return new PerkAttributeEntry(type, weight);
    }

    @Override
    @Nonnull
    public String serialize() {
        return this.type.getRegistryName().toString() + ";" + this.weight;
    }
}

