/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.base;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataSet;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public abstract class ConfigDataAdapter<T extends ConfigDataSet> {
    private ForgeConfigSpec.ConfigValue<List<? extends String>> registryStore = null;
    private final ModConfig.Type registryConfigType;
    List<T> configuredValues = null;

    public ConfigDataAdapter() {
        this(ModConfig.Type.SERVER);
    }

    public ConfigDataAdapter(ModConfig.Type type) {
        this.registryConfigType = type;
    }

    protected String translationKey(String key) {
        return String.format("config.registry.%s.%s", this.getSectionName(), key);
    }

    public final void configBuilt(ForgeConfigSpec.ConfigValue<List<? extends String>> createdValue) {
        this.registryStore = createdValue;
    }

    public synchronized List<T> getConfiguredValues() {
        if (this.registryStore == null) {
            return new ArrayList();
        }
        if (this.configuredValues == null) {
            this.configuredValues = new ArrayList<T>();
            for (String str : (List)this.registryStore.get()) {
                T val;
                try {
                    val = this.deserialize(str);
                }
                catch (IllegalArgumentException exc) {
                    AstralSorcery.log.error("Skipping configured entry in " + this.getSectionName() + "!");
                    AstralSorcery.log.error(exc.getMessage());
                    continue;
                }
                if (val == null) continue;
                this.configuredValues.add(val);
            }
        }
        return this.configuredValues;
    }

    @Nullable
    public synchronized T getRandomValue(Random rand) {
        return (T)((ConfigDataSet)MiscUtils.getRandomEntry(this.getConfiguredValues(), rand));
    }

    public abstract List<T> getDefaultValues();

    public abstract String getSectionName();

    public abstract String getCommentDescription();

    public abstract String getTranslationKey();

    public abstract Predicate<Object> getValidator();

    public ModConfig.Type getRegistryConfigType() {
        return this.registryConfigType;
    }

    @Nullable
    public abstract T deserialize(String var1) throws IllegalArgumentException;
}

