/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.base;

import com.google.common.base.Splitter;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ModConfig;

public class BaseConfiguration {
    private static final Map<ModConfig.Type, BaseConfiguration> REGISTERED_CONFIGS = new HashMap<ModConfig.Type, BaseConfiguration>();
    public static final Splitter DOT_SPLITTER = Splitter.on((String)".");
    private final List<ConfigEntry> configEntries = new ArrayList<ConfigEntry>();
    private final ModConfig.Type configType;

    protected BaseConfiguration(ModConfig.Type configType) {
        this.configType = configType;
    }

    public <T extends ConfigEntry> T addConfigEntry(T configEntry) {
        configEntry.setConfigType(this.configType);
        this.configEntries.add(configEntry);
        return configEntry;
    }

    public void buildConfiguration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        for (ConfigEntry entry : this.configEntries) {
            List splitPath = DOT_SPLITTER.splitToList((CharSequence)entry.getPath());
            builder.push(splitPath);
            entry.accept(builder);
            builder.pop(splitPath.size());
        }
        this.makeAndRegister(builder.build(), "astralsorcery");
    }

    private void makeAndRegister(ForgeConfigSpec spec, String file) {
        String fileName = this.configType == ModConfig.Type.SERVER ? String.format("%s.toml", file) : String.format("%s-%s.toml", file, this.configType.extension());
        ModContainer ct = AstralSorcery.getModContainer();
        ModConfig cfg = new ModConfig(this.configType, spec, ct, fileName);
        ct.addConfig(cfg);
        REGISTERED_CONFIGS.put(this.configType, this);
    }

    public static void refreshConfiguration(ModConfig.Loading cfgLoadEvent) {
        BaseConfiguration cfg;
        ModConfig config = cfgLoadEvent.getConfig();
        if (config.getModId().equals("astralsorcery") && (cfg = REGISTERED_CONFIGS.get(config.getType())) != null) {
            cfg.configEntries.forEach(ConfigEntry::reload);
        }
    }
}

