/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crystal.property;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crystal.CrystalProperty;
import hellfirepvp.astralsorcery.common.crystal.source.AttunedSourceInstance;
import hellfirepvp.astralsorcery.common.crystal.source.Crystal;
import hellfirepvp.astralsorcery.common.crystal.source.Ritual;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.lib.CrystalPropertiesAS;

public class PropertyConstellation
extends CrystalProperty {
    private final IWeakConstellation cst;

    public PropertyConstellation(IWeakConstellation cst) {
        super(AstralSorcery.key("constellation." + cst.getSimpleName()));
        this.cst = cst;
        this.setRequiredResearch(ResearchProgression.ATTUNEMENT);
        this.addUsage(ctx -> (ctx.isSource(CrystalPropertiesAS.Sources.SOURCE_COLLECTOR_CRYSTAL) || ctx.isSource(CrystalPropertiesAS.Sources.SOURCE_TILE_COLLECTOR_CRYSTAL)) && cst.equals(((AttunedSourceInstance)ctx.getSource()).getAttunedConstellation()));
        this.addModifier((value, originalValue, propertyLevel, context) -> {
            Crystal crystal;
            if ((context.isSource(CrystalPropertiesAS.Sources.SOURCE_COLLECTOR_CRYSTAL) || context.isSource(CrystalPropertiesAS.Sources.SOURCE_TILE_COLLECTOR_CRYSTAL)) && (crystal = (Crystal)context.getSource()) != null && cst.equals(crystal.getAttunedConstellation())) {
                return value * (1.0 + 0.3 * (double)propertyLevel);
            }
            return value;
        });
        this.addUsage(ctx -> (ctx.isSource(CrystalPropertiesAS.Sources.SOURCE_RITUAL_PEDESTAL) || ctx.isSource(CrystalPropertiesAS.Sources.SOURCE_TILE_RITUAL_PEDESTAL)) && cst.equals(((AttunedSourceInstance)ctx.getSource()).getAttunedConstellation()));
        this.addModifier((value, originalValue, propertyLevel, context) -> {
            Ritual ritual;
            if ((context.isSource(CrystalPropertiesAS.Sources.SOURCE_RITUAL_PEDESTAL) || context.isSource(CrystalPropertiesAS.Sources.SOURCE_TILE_RITUAL_PEDESTAL)) && (ritual = (Ritual)context.getSource()) != null && cst.equals(ritual.getAttunedConstellation())) {
                return value * (1.0 + 0.35 * (double)propertyLevel);
            }
            return value;
        });
    }

    public IWeakConstellation getConstellation() {
        return this.cst;
    }

    @Override
    public int getMaxTier() {
        return 2;
    }

    @Override
    public boolean canSee(PlayerProgress progress) {
        return super.canSee(progress) && progress.hasConstellationDiscovered(this.cst);
    }
}

