/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeSerializer;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInfusion;
import hellfirepvp.astralsorcery.common.lib.RecipeSerializersAS;
import hellfirepvp.astralsorcery.common.util.data.JsonHelper;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class LiquidInfusionSerializer
extends CustomRecipeSerializer<LiquidInfusion> {
    public LiquidInfusionSerializer() {
        super(RecipeSerializersAS.LIQUID_INFUSION);
    }

    public LiquidInfusion read(ResourceLocation recipeId, JsonObject json) {
        ResourceLocation fluidKey = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluidInput"));
        Fluid fluidInput = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidKey);
        if (fluidInput == null || fluidInput == Fluids.field_204541_a) {
            throw new JsonSyntaxException("Unknown fluid: " + fluidKey);
        }
        Ingredient input = CraftingHelper.getIngredient((JsonElement)json.get("input"));
        ItemStack output = JsonHelper.getItemStack(json.get("output"), "output");
        float consumptionChance = JSONUtils.func_151217_k((JsonObject)json, (String)"consumptionChance");
        int duration = JSONUtils.func_151203_m((JsonObject)json, (String)"duration");
        boolean consumeMultipleFluids = JSONUtils.func_151209_a((JsonObject)json, (String)"consumeMultipleFluids", (boolean)false);
        boolean acceptChaliceInput = JSONUtils.func_151209_a((JsonObject)json, (String)"acceptChaliceInput", (boolean)true);
        boolean copyNBTToOutputs = JSONUtils.func_151209_a((JsonObject)json, (String)"copyNBTToOutputs", (boolean)false);
        return new LiquidInfusion(recipeId, duration, fluidInput, input, output, consumptionChance, consumeMultipleFluids, acceptChaliceInput, copyNBTToOutputs);
    }

    public LiquidInfusion read(ResourceLocation recipeId, PacketBuffer buffer) {
        return LiquidInfusion.read(recipeId, buffer);
    }

    @Override
    public void write(JsonObject object, LiquidInfusion recipe) {
        recipe.write(object);
    }

    public void write(PacketBuffer buffer, LiquidInfusion recipe) {
        recipe.write(buffer);
    }
}

