/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.helper.IHandlerRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.RecipeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.items.IItemHandler;

public class ResolvingRecipeType<C extends IItemHandler, T extends IHandlerRecipe<C>, R extends RecipeCraftingContext<T, C>> {
    private final ResourceLocation id;
    private final Class<T> baseClass;
    private final BiPredicate<T, R> matchFct;
    private final IRecipeType<T> type;

    public ResolvingRecipeType(String name, Class<T> baseClass, BiPredicate<T, R> matchFct) {
        this(AstralSorcery.key(name), baseClass, matchFct);
    }

    public ResolvingRecipeType(ResourceLocation id, Class<T> baseClass, BiPredicate<T, R> matchFct) {
        this.id = id;
        this.baseClass = baseClass;
        this.matchFct = matchFct;
        this.type = new IRecipeType<T>(){

            public String toString() {
                return ResolvingRecipeType.this.id.func_110623_a();
            }
        };
        Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)this.getRegistryName(), this.getType());
    }

    @Nonnull
    public List<T> getAllRecipes() {
        RecipeManager mgr = RecipeHelper.getRecipeManager();
        if (mgr == null) {
            return Collections.emptyList();
        }
        Collection recipeSet = mgr.func_215366_a(this.type).values();
        ArrayList<IHandlerRecipe> recipes = new ArrayList<IHandlerRecipe>(recipeSet.size());
        for (IRecipe rec : recipeSet) {
            recipes.add((IHandlerRecipe)rec);
        }
        return recipes;
    }

    @Nonnull
    public List<T> getRecipes(Predicate<T> test) {
        return this.getAllRecipes().stream().filter(test).collect(Collectors.toList());
    }

    public final Class<T> getBaseClass() {
        return this.baseClass;
    }

    public IRecipeType<T> getType() {
        return this.type;
    }

    public ResourceLocation getRegistryName() {
        return this.id;
    }

    @Nullable
    public T findRecipe(R context) {
        return (T)MiscUtils.iterativeSearch(this.getAllRecipes(), recipe -> this.matchFct.test((IHandlerRecipe)recipe, context));
    }

    @Nonnull
    public List<T> findMatchingRecipes(R context) {
        return this.getAllRecipes().stream().filter(recipe -> this.matchFct.test((IHandlerRecipe)recipe, context)).collect(Collectors.toList());
    }
}

