/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.base.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellationSpecialShowup;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ConstellationHandler {
    private final WorldContext ctx;
    private final Map<MoonPhase, LinkedList<IConstellation>> activeMap = Maps.newHashMap();
    private final Map<IConstellation, MoonPhase> directOffsetMap = Maps.newHashMap();
    private int lastRecordedDay = -1;
    private final List<IConstellation> visibleSpecialConstellations = Lists.newArrayList();

    ConstellationHandler(WorldContext context) {
        this.ctx = context;
    }

    @Nullable
    public MoonPhase getOffset(IConstellation cst) {
        return this.directOffsetMap.get(cst);
    }

    public boolean isActiveCurrently(IConstellation cst, MoonPhase phase) {
        return this.isActiveInPhase(cst, phase) || this.visibleSpecialConstellations.contains(cst);
    }

    public boolean isActiveInPhase(IConstellation cst, MoonPhase phase) {
        return this.activeMap.get((Object)phase).contains(cst);
    }

    public int getLastTrackedDay() {
        return this.lastRecordedDay;
    }

    public void tick(World world) {
        int currentDay;
        int dayDifference;
        if (this.activeMap.isEmpty()) {
            this.initialize();
        }
        if ((dayDifference = (currentDay = (int)(world.func_72820_D() / (long)((Integer)GeneralConfig.CONFIG.dayLength.get()).intValue())) - this.lastRecordedDay) != 0) {
            this.lastRecordedDay = currentDay;
            this.updateActiveConstellations(world);
        }
    }

    private void updateActiveConstellations(World world) {
        this.visibleSpecialConstellations.clear();
        MoonPhase ph = MoonPhase.fromWorld((IWorld)world);
        LinkedList<IConstellation> active = new LinkedList<IConstellation>(this.activeMap.computeIfAbsent(ph, p -> Lists.newLinkedList()));
        for (IConstellationSpecialShowup cst : ConstellationRegistry.getSpecialShowupConstellations()) {
            if (!cst.doesShowUp(world, this.lastRecordedDay)) continue;
            this.visibleSpecialConstellations.add(cst);
        }
        active.addAll(this.visibleSpecialConstellations);
        this.ctx.getActiveCelestialsHandler().updatePositions(active);
    }

    private void initialize() {
        this.activeMap.clear();
        this.directOffsetMap.clear();
        for (MoonPhase ph : MoonPhase.values()) {
            this.activeMap.put(ph, Lists.newLinkedList());
        }
        Random rand = this.ctx.getRandom();
        boolean[] occupiedSlots = new boolean[MoonPhase.values().length];
        Arrays.fill(occupiedSlots, false);
        LinkedList weakAndMajor = Lists.newLinkedList(ConstellationRegistry.getWeakConstellations());
        Collections.shuffle(weakAndMajor, rand);
        weakAndMajor.forEach(c -> this.addConstellationCycle((IConstellation)c, rand, occupiedSlots));
        LinkedList constellations = Lists.newLinkedList(ConstellationRegistry.getMinorConstellations());
        Collections.shuffle(constellations, rand);
        constellations.forEach(c -> this.addConstellationCycle((IConstellation)c, rand, occupiedSlots));
    }

    private void addConstellationCycle(IConstellation cst, Random rand, boolean[] slots) {
        if (cst instanceof IConstellationSpecialShowup) {
            return;
        }
        if (cst instanceof IMinorConstellation) {
            for (MoonPhase ph : ((IMinorConstellation)cst).getShowupMoonPhases(this.ctx.getSeed())) {
                this.activeMap.get((Object)ph).add(cst);
            }
        } else {
            int start = this.searchForSpot(rand, slots);
            this.occupySlots(start, slots);
            if (this.getSlots(slots) <= 0) {
                Arrays.fill(slots, false);
            }
            for (int i = 0; i < 5; ++i) {
                MoonPhase ph = this.getPhase(start + i);
                this.activeMap.get((Object)ph).add(cst);
            }
            this.directOffsetMap.put(cst, this.getPhase(start));
        }
    }

    private MoonPhase getPhase(int rIndex) {
        int moonPhaseCount = MoonPhase.values().length;
        while (rIndex < 0) {
            rIndex += moonPhaseCount;
        }
        return MoonPhase.values()[rIndex % moonPhaseCount];
    }

    private int searchForSpot(Random r, boolean[] occupied) {
        int start;
        boolean foundFree = false;
        int tries = 5;
        do {
            --tries;
            start = r.nextInt(8);
            int count = this.getSlots(occupied);
            if (count < 3) continue;
            foundFree = true;
        } while (!foundFree && tries > 0);
        return start;
    }

    private void occupySlots(int start, boolean[] occupied) {
        for (int i = 0; i < 5; ++i) {
            int index = (start + i) % 8;
            if (occupied[index]) continue;
            occupied[index] = true;
        }
    }

    private int getSlots(boolean[] array) {
        int it = 0;
        for (boolean b : array) {
            if (b) continue;
            ++it;
        }
        return it;
    }
}

