/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle.effect;

import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class MantleEffectFornax
extends MantleEffect {
    public static FornaxConfig CONFIG = new FornaxConfig();

    public MantleEffectFornax() {
        super(ConstellationsAS.fornax);
    }

    @Override
    protected void attachEventListeners(IEventBus bus) {
        super.attachEventListeners(bus);
        bus.addListener(this::onHurt);
    }

    private void onHurt(LivingHurtEvent event) {
        World world = event.getEntityLiving().func_130014_f_();
        if (world.func_201670_d()) {
            return;
        }
        LivingEntity attacked = event.getEntityLiving();
        Entity attacker = event.getSource().func_76346_g();
        if (attacker instanceof LivingEntity) {
            if (attacked instanceof ServerPlayerEntity && MiscUtils.isPlayerFakeMP((ServerPlayerEntity)attacked)) {
                return;
            }
            if (attacker.func_70027_ad() && ItemMantle.getEffect((LivingEntity)attacker, ConstellationsAS.fornax) != null) {
                event.setAmount((float)((double)event.getAmount() * (Double)MantleEffectFornax.CONFIG.damageIncreaseInFire.get()));
            }
        }
        if (event.getSource().func_76347_k() && ItemMantle.getEffect(attacked, ConstellationsAS.fornax) != null) {
            if ((Double)MantleEffectFornax.CONFIG.healPercentFromFireDamage.get() > 0.0) {
                attacked.func_70691_i((float)((double)event.getAmount() * (Double)MantleEffectFornax.CONFIG.healPercentFromFireDamage.get()));
            }
            event.setAmount((float)((double)event.getAmount() * (Double)MantleEffectFornax.CONFIG.damageReductionInFire.get()));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
        super.tickClient(player);
        if (player.func_70027_ad()) {
            this.playCapeSparkles(player, 0.75f);
        } else {
            this.playCapeSparkles(player, 0.25f);
        }
    }

    @Override
    protected boolean usesTickMethods() {
        return true;
    }

    @Override
    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    public static class FornaxConfig
    extends MantleEffect.Config {
        private final double defaultDamageReductionInFire = 0.4f;
        private final double defaultDamageIncreaseInFire = 1.6f;
        private final double defaultHealPercentFromFireDamage = 0.6f;
        public ForgeConfigSpec.DoubleValue damageReductionInFire;
        public ForgeConfigSpec.DoubleValue damageIncreaseInFire;
        public ForgeConfigSpec.DoubleValue healPercentFromFireDamage;

        public FornaxConfig() {
            super("fornax");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.damageReductionInFire = cfgBuilder.comment("Sets the multiplier for how much damage you take from fire damage while wearing a fornax mantle.").translation(this.translationKey("damageReductionInFire")).defineInRange("damageReductionInFire", this.defaultDamageReductionInFire, 0.0, 1.0);
            this.damageIncreaseInFire = cfgBuilder.comment("Sets the multiplier for how much more damage the player deals when ignited while wearing a fornax mantle.").translation(this.translationKey("damageIncreaseInFire")).defineInRange("damageIncreaseInFire", this.defaultDamageIncreaseInFire, 1.0, 3.0);
            this.healPercentFromFireDamage = cfgBuilder.comment("Sets the multiplier for how much healing the player receives from the original damage when being hit by fire damage.").translation(this.translationKey("healPercentFromFireDamage")).defineInRange("healPercentFromFireDamage", this.defaultHealPercentFromFireDamage, 0.0, 3.0);
        }
    }
}

