/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.cmd.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import hellfirepvp.astralsorcery.common.cmd.argument.ArgumentTypeConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.LogicalSide;

public class CommandConstellation {
    private CommandConstellation() {
    }

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"constellation").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197057_a((String)"memorize").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"constellation", (ArgumentType)ArgumentTypeConstellation.any()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> {
            ServerPlayerEntity target = EntityArgument.func_197089_d((CommandContext)ctx, (String)"player");
            IConstellation cst = (IConstellation)ctx.getArgument("constellation", IConstellation.class);
            return CommandConstellation.markConstellationMemorized((CommandSource)ctx.getSource(), (PlayerEntity)target, cst);
        }))).executes(ctx -> {
            IConstellation cst = (IConstellation)ctx.getArgument("constellation", IConstellation.class);
            return CommandConstellation.markConstellationMemorized((CommandSource)ctx.getSource(), null, cst);
        })))).then(Commands.func_197057_a((String)"discover").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"constellation", (ArgumentType)ArgumentTypeConstellation.any()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> {
            ServerPlayerEntity target = EntityArgument.func_197089_d((CommandContext)ctx, (String)"player");
            IConstellation cst = (IConstellation)ctx.getArgument("constellation", IConstellation.class);
            return CommandConstellation.discoverConstellation((CommandSource)ctx.getSource(), (PlayerEntity)target, cst);
        }))).executes(ctx -> {
            IConstellation cst = (IConstellation)ctx.getArgument("constellation", IConstellation.class);
            return CommandConstellation.discoverConstellation((CommandSource)ctx.getSource(), null, cst);
        })));
    }

    private static int markConstellationMemorized(CommandSource src, @Nullable PlayerEntity target, IConstellation cst) throws CommandSyntaxException {
        ServerPlayerEntity source = src.func_197035_h();
        target = target != null ? target : source;
        ITextComponent targetName = target.func_145748_c_();
        PlayerProgress progress = ResearchHelper.getProgress(target, LogicalSide.SERVER);
        if (!progress.isValid() || progress.hasSeenConstellation(cst)) {
            source.func_145747_a((ITextComponent)new StringTextComponent("Failed! ").func_230529_a_(targetName).func_240702_b_(" has already seen ").func_230529_a_((ITextComponent)cst.getConstellationName()).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            return 0;
        }
        if (ResearchManager.memorizeConstellation(cst, target)) {
            ResearchHelper.sendConstellationMemorizationMessage((ICommandSource)target, progress, cst);
            source.func_145747_a((ITextComponent)new StringTextComponent("Success! ").func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
            return 1;
        }
        source.func_145747_a((ITextComponent)new StringTextComponent("Failed!").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        return 0;
    }

    private static int discoverConstellation(CommandSource src, @Nullable PlayerEntity target, IConstellation cst) throws CommandSyntaxException {
        ServerPlayerEntity source = src.func_197035_h();
        target = target != null ? target : source;
        ITextComponent targetName = target.func_145748_c_();
        PlayerProgress progress = ResearchHelper.getProgress(target, LogicalSide.SERVER);
        if (!progress.isValid() || progress.hasConstellationDiscovered(cst)) {
            source.func_145747_a((ITextComponent)new StringTextComponent("Failed! ").func_230529_a_(targetName).func_240702_b_(" has already discovered ").func_230529_a_((ITextComponent)cst.getConstellationName()).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            return 0;
        }
        if (ResearchManager.discoverConstellation(cst, target)) {
            ResearchHelper.sendConstellationDiscoveryMessage((ICommandSource)target, cst);
            source.func_145747_a((ITextComponent)new StringTextComponent("Success! ").func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
            return 1;
        }
        source.func_145747_a((ITextComponent)new StringTextComponent("Failed!").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        return 0;
    }
}

