/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.tile.altar;

import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.StructureTypesAS;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public enum AltarType {
    DISCOVERY(ResearchProgression.BASIC_CRAFT, 100, 1, () -> BlocksAS.ALTAR_DISCOVERY.func_199767_j(), () -> StructureTypesAS.EMPTY, 6, 7, 8, 11, 12, 13, 16, 17, 18),
    ATTUNEMENT(ResearchProgression.ATTUNEMENT, 200, 2, () -> BlocksAS.ALTAR_ATTUNEMENT.func_199767_j(), () -> StructureTypesAS.PTYPE_ALTAR_ATTUNEMENT, 0, 4, 6, 7, 8, 11, 12, 13, 16, 17, 18, 20, 24),
    CONSTELLATION(ResearchProgression.CONSTELLATION, 400, 2, () -> BlocksAS.ALTAR_CONSTELLATION.func_199767_j(), () -> StructureTypesAS.PTYPE_ALTAR_CONSTELLATION, slot -> slot != 2 && slot != 10 && slot != 14 && slot != 22),
    RADIANCE(ResearchProgression.RADIANCE, 600, 3, () -> BlocksAS.ALTAR_RADIANCE.func_199767_j(), () -> StructureTypesAS.PTYPE_ALTAR_TRAIT, slot -> true);

    private final ResearchProgression associatedTier;
    private final int defaultAltarCraftingDuration;
    private final int minimumSources;
    private final Supplier<Item> altarItemSupplier;
    private final Supplier<StructureType> structureSupplier;
    private final Predicate<Integer> slotValidator;

    private AltarType(ResearchProgression progressTier, int defaultAltarCraftingDuration, int minimumSources, Supplier<Item> altarItemSupplier, Supplier<StructureType> structureSupplier, int ... validSlots) {
        this.associatedTier = progressTier;
        this.defaultAltarCraftingDuration = defaultAltarCraftingDuration;
        this.minimumSources = minimumSources;
        this.altarItemSupplier = altarItemSupplier;
        this.structureSupplier = structureSupplier;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot : validSlots) {
            slots.add(slot);
        }
        this.slotValidator = slots::contains;
    }

    private AltarType(ResearchProgression progressTier, int defaultAltarCraftingDuration, int minimumSources, Supplier<Item> altarItemSupplier, Supplier<StructureType> structureSupplier, Predicate<Integer> slotValidator) {
        this.associatedTier = progressTier;
        this.defaultAltarCraftingDuration = defaultAltarCraftingDuration;
        this.minimumSources = minimumSources;
        this.altarItemSupplier = altarItemSupplier;
        this.structureSupplier = structureSupplier;
        this.slotValidator = slotValidator;
    }

    @Nonnull
    public ResearchProgression getAssociatedTier() {
        return this.associatedTier;
    }

    @Nonnull
    public StructureType getRequiredStructure() {
        return this.structureSupplier.get();
    }

    @Nonnull
    public ItemStack getAltarItemRepresentation() {
        return new ItemStack((IItemProvider)this.altarItemSupplier.get());
    }

    public boolean hasSlot(int slotId) {
        return this.slotValidator.test(slotId);
    }

    public int getStarlightCapacity() {
        return (int)(1000.0 * Math.pow(2.0, this.ordinal()));
    }

    public int getDefaultAltarCraftingDuration() {
        return this.defaultAltarCraftingDuration;
    }

    public int getMinimumSources() {
        return this.minimumSources;
    }

    public boolean isThisLEThan(AltarType type) {
        return this.ordinal() <= type.ordinal();
    }

    public boolean isThisGEThan(AltarType type) {
        return this.ordinal() >= type.ordinal();
    }
}

