/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.tile;

import hellfirepvp.astralsorcery.common.block.base.BlockStarlightNetwork;
import hellfirepvp.astralsorcery.common.block.base.CustomItemBlock;
import hellfirepvp.astralsorcery.common.block.tile.crystal.CollectorCrystalType;
import hellfirepvp.astralsorcery.common.constellation.ConstellationItem;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crystal.CalculationContext;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.crystal.source.AttunedSourceInstance;
import hellfirepvp.astralsorcery.common.data.research.GatedKnowledge;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.item.block.ItemBlockCollectorCrystal;
import hellfirepvp.astralsorcery.common.lib.CrystalPropertiesAS;
import hellfirepvp.astralsorcery.common.tile.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.observerlib.api.block.BlockStructureObserver;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;

public abstract class BlockCollectorCrystal
extends BlockStarlightNetwork
implements BlockStructureObserver,
CustomItemBlock {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)16.0, (double)11.5);
    private static final float PLAYER_HARVEST_HARDNESS = 4.0f;

    public BlockCollectorCrystal(CollectorCrystalType type) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)type.getMaterialColor()).func_200948_a(-1.0f, 3600000.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200947_a(SoundType.field_185853_f).func_235838_a_(state -> 11));
    }

    public abstract Class<? extends ItemBlockCollectorCrystal> getItemBlockClass();

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> toolTip, ITooltipFlag flag) {
        super.func_190948_a(stack, world, toolTip, flag);
        CrystalAttributes attr = CrystalAttributes.getCrystalAttributes(stack);
        CrystalAttributes.TooltipResult result = null;
        if (attr != null) {
            result = attr.addTooltip(toolTip, CalculationContext.Builder.withSource(new AttunedSourceInstance(CrystalPropertiesAS.Sources.SOURCE_TILE_COLLECTOR_CRYSTAL, ((ConstellationItem)stack.func_77973_b()).getAttunedConstellation(stack))).addUsage(CrystalPropertiesAS.Usages.USE_COLLECTOR_CRYSTAL).addUsage(CrystalPropertiesAS.Usages.USE_LENS_TRANSFER).build());
        }
        if (result != null) {
            IMinorConstellation tr;
            PlayerProgress clientProgress = ResearchHelper.getClientProgress();
            ProgressionTier tier = clientProgress.getTierReached();
            boolean addedMissing = result != CrystalAttributes.TooltipResult.ADDED_ALL;
            IWeakConstellation c = ((ConstellationItem)stack.func_77973_b()).getAttunedConstellation(stack);
            if (c != null) {
                if (GatedKnowledge.COLLECTOR_TYPE.canSee(tier) && clientProgress.hasConstellationDiscovered(c)) {
                    toolTip.add((ITextComponent)new TranslationTextComponent("crystal.info.astralsorcery.collect.type", new Object[]{c.getConstellationName().func_240699_a_(TextFormatting.BLUE)}).func_240699_a_(TextFormatting.GRAY));
                } else if (!addedMissing) {
                    toolTip.add((ITextComponent)new TranslationTextComponent("astralsorcery.progress.missing.knowledge").func_240699_a_(TextFormatting.GRAY));
                }
            }
            if ((tr = ((ConstellationItem)stack.func_77973_b()).getTraitConstellation(stack)) != null) {
                if (GatedKnowledge.CRYSTAL_TRAIT.canSee(tier) && clientProgress.hasConstellationDiscovered(tr)) {
                    toolTip.add((ITextComponent)new TranslationTextComponent("crystal.info.astralsorcery.trait", new Object[]{tr.getConstellationName().func_240699_a_(TextFormatting.BLUE)}).func_240699_a_(TextFormatting.GRAY));
                } else if (!addedMissing) {
                    toolTip.add((ITextComponent)new TranslationTextComponent("astralsorcery.progress.missing.knowledge").func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        TileCollectorCrystal crystal = MiscUtils.getTileAt(world, pos, TileCollectorCrystal.class, false);
        if (crystal != null && crystal.isPlayerMade()) {
            int i = ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos) ? 30 : 100;
            return player.getDigSpeed(state, pos) / 4.0f / (float)i;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        TileCollectorCrystal tcc = MiscUtils.getTileAt((IBlockReader)world, pos, TileCollectorCrystal.class, true);
        Item i = stack.func_77973_b();
        if (tcc != null && i instanceof ItemBlockCollectorCrystal) {
            ItemBlockCollectorCrystal ibcc = (ItemBlockCollectorCrystal)i;
            UUID playerUUID = null;
            if (entity instanceof PlayerEntity) {
                playerUUID = entity.func_110124_au();
            }
            tcc.updateData(playerUUID, ibcc.getCollectorType());
        }
        super.func_180633_a(world, pos, state, entity, stack);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileCollectorCrystal();
    }
}

