/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon;

import hellfirepvp.astralsorcery.common.base.patreon.FlareColor;
import hellfirepvp.astralsorcery.common.base.patreon.entity.PatreonFlare;
import hellfirepvp.astralsorcery.common.base.patreon.entity.PatreonPartialEntity;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;

public class PatreonEffect {
    protected static final Random rand = new Random();
    private final FlareColor flareColor;
    private final UUID effectUUID;

    public PatreonEffect(UUID effectUUID, @Nullable FlareColor flareColor) {
        this.effectUUID = effectUUID;
        this.flareColor = flareColor;
    }

    @Nullable
    public FlareColor getFlareColor() {
        return this.flareColor;
    }

    public boolean hasPartialEntity() {
        return this.getFlareColor() != null;
    }

    public UUID getEffectUUID() {
        return this.effectUUID;
    }

    public void initialize() {
    }

    public void attachEventListeners(IEventBus bus) {
    }

    public void attachTickListeners(Consumer<ITickHandler> registrar) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void doClientEffect(PlayerEntity player) {
    }

    @Nullable
    public PatreonPartialEntity createEntity(UUID playerUUID) {
        if (this.hasPartialEntity()) {
            return new PatreonFlare(this.getEffectUUID(), playerUUID);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatreonEffect that = (PatreonEffect)o;
        return Objects.equals(this.effectUUID, that.effectUUID);
    }

    public int hashCode() {
        return Objects.hash(this.effectUUID);
    }
}

