/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary.link;

import hellfirepvp.astralsorcery.common.auxiliary.link.IItemLinkingTool;
import hellfirepvp.astralsorcery.common.auxiliary.link.LinkableTileEntity;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class LinkHandler
implements ITickHandler {
    private static final LinkHandler instance = new LinkHandler();
    private static final Map<UUID, LinkSession> players = new HashMap<UUID, LinkSession>();

    private LinkHandler() {
    }

    public static LinkHandler getInstance() {
        return instance;
    }

    @Nullable
    public static LinkSession getActiveSession(PlayerEntity player) {
        return players.get(player.func_110124_au());
    }

    @Nonnull
    public static RightClickResult onInteractEntity(PlayerEntity clicked, LivingEntity entity) {
        LinkSession session = LinkSession.entity(entity);
        players.put(clicked.func_110124_au(), session);
        return new RightClickResult(RightClickResultType.SELECT_START, session);
    }

    @Nonnull
    public static RightClickResult onInteractBlock(PlayerEntity clicked, World world, BlockPos pos, boolean sneak) {
        UUID playerUUID = clicked.func_110124_au();
        if (!players.containsKey(playerUUID)) {
            LinkableTileEntity tile = MiscUtils.getTileAt((IBlockReader)world, pos, LinkableTileEntity.class, true);
            if (tile == null) {
                return new RightClickResult(RightClickResultType.NONE, null);
            }
            LinkSession session = LinkSession.tile(tile);
            players.put(playerUUID, session);
            return new RightClickResult(RightClickResultType.SELECT_START, session);
        }
        LinkSession session = players.get(playerUUID);
        if (session.getType() == LinkType.ENTITY) {
            LinkableTileEntity tile = MiscUtils.getTileAt((IBlockReader)world, pos, LinkableTileEntity.class, true);
            if (tile == null) {
                players.remove(playerUUID);
                return new RightClickResult(RightClickResultType.NONE, null);
            }
            session.setSelected(tile);
            return new RightClickResult(RightClickResultType.TRY_LINK, session);
        }
        if (sneak) {
            return new RightClickResult(RightClickResultType.TRY_UNLINK, session);
        }
        return new RightClickResult(RightClickResultType.TRY_LINK, session);
    }

    public static void processInteraction(RightClickResult result, PlayerEntity playerIn, World world, BlockPos pos) {
        LinkSession session = result.getLinkingSession();
        LinkableTileEntity tile = session.getSelectedTile();
        switch (result.getType()) {
            case SELECT_START: {
                if (session.getType() == LinkType.ENTITY) {
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.misc.link.start", new Object[]{result.getLinkingSession().getSelectedEntity().func_145748_c_()}).func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
                    break;
                }
                String name = tile.getUnLocalizedDisplayName();
                if (!tile.onSelect(playerIn) || name == null) break;
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.misc.link.start", new Object[]{new TranslationTextComponent(name)}).func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
                break;
            }
            case TRY_LINK: {
                TileEntity te = MiscUtils.getTileAt((IBlockReader)world, pos, TileEntity.class, true);
                String linkedToName = "astralsorcery.misc.link.link.block";
                if (te instanceof LinkableTileEntity) {
                    if (!((LinkableTileEntity)te).doesAcceptLinks()) {
                        return;
                    }
                    String unloc = ((LinkableTileEntity)te).getUnLocalizedDisplayName();
                    if (unloc != null) {
                        linkedToName = unloc;
                    }
                }
                if (session.getType() == LinkType.ENTITY && te instanceof LinkableTileEntity) {
                    LinkableTileEntity linkTarget = (LinkableTileEntity)te;
                    LivingEntity linked = session.getSelectedEntity();
                    if (!linkTarget.tryLinkEntity(playerIn, linked)) break;
                    linkTarget.onEntityLinkCreate(playerIn, linked);
                    break;
                }
                if (!tile.tryLinkBlock(playerIn, pos)) break;
                tile.onBlockLinkCreate(playerIn, pos);
                String linkedFrom = tile.getUnLocalizedDisplayName();
                if (linkedFrom == null) break;
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.misc.link.link", new Object[]{new TranslationTextComponent(linkedFrom), new TranslationTextComponent(linkedToName)}).func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
                break;
            }
            case TRY_UNLINK: {
                String linkedFrom;
                String unloc;
                if (!tile.tryUnlink(playerIn, pos)) break;
                String linkedToName = "astralsorcery.misc.link.link.block";
                TileEntity te = MiscUtils.getTileAt((IBlockReader)world, pos, TileEntity.class, true);
                if (te instanceof LinkableTileEntity && (unloc = ((LinkableTileEntity)te).getUnLocalizedDisplayName()) != null) {
                    linkedToName = unloc;
                }
                if ((linkedFrom = tile.getUnLocalizedDisplayName()) == null) break;
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.misc.link.unlink", new Object[]{new TranslationTextComponent(linkedFrom), new TranslationTextComponent(linkedToName)}).func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
                break;
            }
            case NONE: {
                break;
            }
        }
    }

    public void tick(TickEvent.Type type, Object ... context) {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (server == null) {
            return;
        }
        Iterator<UUID> iterator = players.keySet().iterator();
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            LinkSession session = players.get(uuid);
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(uuid);
            if (player == null) {
                iterator.remove();
                continue;
            }
            boolean needsRemoval = MiscUtils.getMainOrOffHand((LivingEntity)player, stack -> stack.func_77973_b() instanceof IItemLinkingTool) == null;
            switch (session.getType()) {
                case ENTITY: {
                    LivingEntity entity = session.getSelectedEntity();
                    if (entity.func_70089_S() && entity.func_130014_f_().func_234923_W_().equals(player.func_130014_f_().func_234923_W_())) break;
                    needsRemoval = true;
                    break;
                }
                case BLOCK: {
                    if (session.getSelectedTile().getLinkWorld().func_234923_W_().equals(player.func_130014_f_().func_234923_W_())) break;
                    needsRemoval = true;
                }
            }
            if (!needsRemoval) continue;
            iterator.remove();
            player.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.misc.link.stop").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        }
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "LinkHandler";
    }

    public static enum RightClickResultType {
        SELECT_START,
        TRY_LINK,
        TRY_UNLINK,
        NONE;

    }

    public static enum LinkType {
        ENTITY,
        BLOCK;

    }

    public static class RightClickResult {
        private final RightClickResultType type;
        private final LinkSession linkingSession;

        RightClickResult(RightClickResultType type, LinkSession linkingSession) {
            this.type = type;
            this.linkingSession = linkingSession;
        }

        public RightClickResultType getType() {
            return this.type;
        }

        public LinkSession getLinkingSession() {
            return this.linkingSession;
        }

        public boolean shouldProcess() {
            return this.getType() != RightClickResultType.NONE;
        }
    }

    public static class LinkSession {
        private final LinkType type;
        private LinkableTileEntity selected;
        private final LivingEntity entity;

        private LinkSession(LinkType type, LinkableTileEntity selected, LivingEntity entity) {
            this.type = type;
            this.selected = selected;
            this.entity = entity;
        }

        public static LinkSession tile(LinkableTileEntity selected) {
            return new LinkSession(LinkType.BLOCK, selected, null);
        }

        public static LinkSession entity(LivingEntity entity) {
            return new LinkSession(LinkType.ENTITY, null, entity);
        }

        public LinkType getType() {
            return this.type;
        }

        @Nullable
        public LinkableTileEntity getSelectedTile() {
            return this.selected;
        }

        public void setSelected(LinkableTileEntity selected) {
            this.selected = selected;
        }

        @Nullable
        public LivingEntity getSelectedEntity() {
            return this.entity;
        }
    }
}

