/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.data.config.entry.RenderingConfig;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.EmptyRenderWorld;
import hellfirepvp.astralsorcery.client.util.LightmapUtil;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.reflection.ReflectionHelper;
import hellfirepvp.observerlib.client.util.BufferDecoratorBuilder;
import hellfirepvp.observerlib.client.util.RenderTypeDecorator;
import hellfirepvp.observerlib.common.util.RegistryUtil;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.CompassItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ObjectUtils;

public class RenderingUtils {
    private static final Random rand = new Random();
    private static IBlockDisplayReader plainRenderWorld = null;

    public static long getPositionSeed(BlockPos pos) {
        long seed = 1553015L;
        seed ^= (long)pos.func_177958_n();
        seed ^= (long)pos.func_177956_o();
        return seed ^= (long)pos.func_177952_p();
    }

    @Nullable
    public static TextureAtlasSprite getParticleTexture(FluidStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        ResourceLocation res = stack.getFluid().getAttributes().getStillTexture(stack);
        if (MissingTextureSprite.func_195675_b().equals((Object)res)) {
            return null;
        }
        return Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b).func_195424_a(res);
    }

    @Nullable
    public static TextureAtlasSprite getParticleTexture(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        ItemModelMesher imm = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        IBakedModel mdl = imm.func_178089_a(stack);
        if (mdl.equals(imm.func_178083_a().func_174951_a())) {
            return null;
        }
        return mdl.getParticleTexture((IModelData)EmptyModelData.INSTANCE);
    }

    @Nullable
    public static TextureAtlasSprite getParticleTexture(BlockState state, @Nullable BlockPos positionHint) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return null;
        }
        BlockPos pos = positionHint != null ? positionHint : BlockPos.field_177992_a;
        try {
            if (state.isAir((IBlockReader)world, pos)) {
                return null;
            }
        }
        catch (Exception exc) {
            return null;
        }
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().getTexture(state, (World)world, pos);
    }

    public static void playBlockBreakParticles(BlockPos pos, @Nullable BlockState actualState, BlockState particleState) {
        VoxelShape voxelshape;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ParticleManager mgr = Minecraft.func_71410_x().field_71452_i;
        try {
            voxelshape = actualState == null ? VoxelShapes.func_197868_b() : actualState.func_196954_c((IBlockReader)world, pos);
        }
        catch (Exception exc) {
            voxelshape = VoxelShapes.func_197868_b();
        }
        voxelshape.func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double xDist = Math.min(1.0, maxX - minX);
            double yDist = Math.min(1.0, maxY - minY);
            double zDist = Math.min(1.0, maxZ - minZ);
            double i = Math.max(2, MathHelper.func_76143_f((double)(xDist / 0.25)));
            double j = Math.max(2, MathHelper.func_76143_f((double)(yDist / 0.25)));
            double k = Math.max(2, MathHelper.func_76143_f((double)(zDist / 0.25)));
            int xx = 0;
            while ((double)xx < i) {
                int yy = 0;
                while ((double)yy < j) {
                    int zz = 0;
                    while ((double)zz < k) {
                        double d4 = ((double)xx + 0.5) / i;
                        double d5 = ((double)yy + 0.5) / j;
                        double d6 = ((double)zz + 0.5) / k;
                        double d7 = d4 * xDist + minX;
                        double d8 = d5 * yDist + minY;
                        double d9 = d6 * zDist + minZ;
                        DiggingParticle p = new DiggingParticle(world, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, particleState);
                        p.func_174845_l();
                        p.func_174846_a(pos);
                        mgr.func_78873_a((Particle)p);
                        ++zz;
                    }
                    ++yy;
                }
                ++xx;
            }
        });
    }

    public static Color clampToColor(int rgb) {
        return RenderingUtils.clampToColorWithMultiplier(rgb, 1.0f);
    }

    public static Color clampToColorWithMultiplier(int rgb, float mul) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 0 & 0xFF;
        return new Color(MathHelper.func_76125_a((int)((int)((float)r * mul)), (int)0, (int)255), MathHelper.func_76125_a((int)((int)((float)g * mul)), (int)0, (int)255), MathHelper.func_76125_a((int)((int)((float)b * mul)), (int)0, (int)255));
    }

    public static Color clampToColor(int r, int g, int b) {
        return new Color(MathHelper.func_76125_a((int)((int)((float)r)), (int)0, (int)255), MathHelper.func_76125_a((int)((int)((float)g)), (int)0, (int)255), MathHelper.func_76125_a((int)((int)((float)b)), (int)0, (int)255));
    }

    public static boolean canEffectExist(EntityComplexFX fx) {
        Entity view = Minecraft.func_71410_x().func_175606_aa();
        if (view == null) {
            view = Minecraft.func_71410_x().field_71439_g;
        }
        if (view == null) {
            return false;
        }
        return fx.getPosition().distanceSquared(view) <= RenderingConfig.CONFIG.getMaxEffectRenderDistanceSq();
    }

    public static void translate(MatrixStack renderStack, float x, float y, float z, Consumer<MatrixStack> fn) {
        renderStack.func_227860_a_();
        renderStack.func_227861_a_((double)x, (double)y, (double)z);
        fn.accept(renderStack);
        renderStack.func_227865_b_();
    }

    public static void draw(int drawMode, VertexFormat format, Consumer<BufferBuilder> fn) {
        RenderingUtils.draw(drawMode, format, (BufferBuilder bufferBuilder) -> {
            fn.accept((BufferBuilder)bufferBuilder);
            return null;
        });
    }

    public static <R> R draw(int drawMode, VertexFormat format, Function<BufferBuilder, R> fn) {
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        buf.func_181668_a(drawMode, format);
        R result = fn.apply(buf);
        RenderingUtils.finishDrawing(buf);
        return result;
    }

    public static void finishDrawing(BufferBuilder buf) {
        RenderingUtils.finishDrawing(buf, null);
    }

    public static void finishDrawing(BufferBuilder buf, @Nullable RenderType type) {
        if (buf.func_227834_j_()) {
            if (type != null) {
                type.func_228631_a_(buf, 0, 0, 0);
            } else {
                buf.func_178977_d();
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)buf);
            }
        }
    }

    public static void refreshDrawing(IVertexBuilder vb, RenderType type) {
        if (vb instanceof BufferBuilder) {
            type.func_228631_a_((BufferBuilder)vb, 0, 0, 0);
            ((BufferBuilder)vb).func_181668_a(type.func_228664_q_(), type.func_228663_p_());
        }
    }

    public static int renderInWorldText(ITextProperties text, Color color, Vector3 at, MatrixStack renderStack, float pTicks, boolean facePlayer) {
        float scale = (float)Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        return RenderingUtils.renderInWorldText(text, color, 0.02f * ((float)Minecraft.func_71410_x().field_71474_y.field_74335_Z / scale), at, renderStack, pTicks, facePlayer);
    }

    public static int renderInWorldText(ITextProperties text, Color color, float scale, Vector3 at, MatrixStack renderStack, float pTicks, boolean facePlayer) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        renderStack.func_227860_a_();
        renderStack.func_227861_a_(at.getX(), at.getY(), at.getZ());
        renderStack.func_227862_a_(scale, -scale, scale);
        if (facePlayer) {
            Entity le = Minecraft.func_71410_x().field_175622_Z;
            if (le == null) {
                le = Minecraft.func_71410_x().field_71439_g;
            }
            float iYaw = RenderingVectorUtils.interpolate(MathHelper.func_76142_g((float)le.field_70126_B), MathHelper.func_76142_g((float)le.field_70177_z), pTicks);
            renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-iYaw + 180.0f));
        }
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        int length = fr.func_238414_a_(text);
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        IReorderingProcessor processedText = LanguageMap.func_74808_a().func_241870_a(text);
        int drawnLength = fr.func_238416_a_(processedText, -((float)length / 2.0f), 0.0f, color.getRGB(), false, matr, (IRenderTypeBuffer)buffers, true, 0, LightmapUtil.getPackedFullbrightCoords());
        buffers.func_228461_a_();
        renderStack.func_227865_b_();
        return drawnLength;
    }

    public static void renderItemAsEntity(ItemStack stack, MatrixStack renderStack, IRenderTypeBuffer buffers, double x, double y, double z, int combinedLight, float pTicks, int age) {
        ItemEntity ei = new ItemEntity((World)Minecraft.func_71410_x().field_71441_e, x, y, z, stack);
        ei.field_70292_b = age;
        ei.field_70290_d = 0.0f;
        ReflectionHelper.setSkipItemPhysicsRender(ei);
        Minecraft.func_71410_x().func_175598_ae().func_229084_a_((Entity)ei, x, y, z, 0.0f, pTicks, renderStack, buffers, combinedLight);
    }

    public static void renderItemStackGUI(MatrixStack renderStack, ItemStack stack, @Nullable String alternativeText) {
        renderStack.func_227860_a_();
        renderStack.func_227861_a_(0.0, 0.0, 100.0);
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        RenderingUtils.renderTranslucentItemStackModelGUI(stack, renderStack, Color.WHITE, Blending.DEFAULT, 255);
        RenderingUtils.mcdefault_renderItemOverlayIntoGUI(font, renderStack, stack, Minecraft.func_71410_x().func_184121_ak(), alternativeText);
        renderStack.func_227865_b_();
    }

    public static void renderTranslucentItemStack(ItemStack stack, MatrixStack renderStack, float pTicks) {
        RenderingUtils.renderTranslucentItemStack(stack, renderStack, pTicks, Color.WHITE, 25);
    }

    public static void renderTranslucentItemStack(ItemStack stack, MatrixStack renderStack, float pTicks, Color overlayColor, int alpha) {
        renderStack.func_227860_a_();
        float sinBobY = MathHelper.func_76126_a((float)(((float)ClientScheduler.getClientTick() + pTicks) / 10.0f)) * 0.1f + 0.1f;
        renderStack.func_227861_a_(0.0, (double)sinBobY, 0.0);
        float ageRotate = ((float)ClientScheduler.getClientTick() + pTicks) / 20.0f;
        renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(ageRotate));
        RenderingUtils.renderTranslucentItemStackModelGround(stack, renderStack, overlayColor, Blending.PREALPHA, alpha);
        renderStack.func_227865_b_();
    }

    public static void renderTranslucentItemStackModelGround(ItemStack stack, MatrixStack renderStack, Color overlayColor, Blending blendMode, int alpha) {
        IBakedModel bakedModel = RenderingUtils.getItemModel(stack);
        ForgeHooksClient.handleCameraTransforms((MatrixStack)renderStack, (IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(AtlasTexture.field_110575_b);
        textureManager.func_229267_b_(AtlasTexture.field_110575_b).setBlurMipmap(false, false);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderingUtils.renderItemModelWithColor(stack, ItemCameraTransforms.TransformType.GROUND, bakedModel, renderStack, renderType -> {
            RenderTypeDecorator decorated = RenderTypeDecorator.wrapSetup((RenderType)renderType, () -> {
                RenderSystem.enableBlend();
                blendMode.apply();
            }, () -> {
                Blending.DEFAULT.apply();
                RenderSystem.disableBlend();
            });
            return buffer.getBuffer((RenderType)decorated);
        }, LightmapUtil.getPackedFullbrightCoords(), OverlayTexture.field_229196_a_, overlayColor, alpha);
        buffer.func_228461_a_();
    }

    public static void renderTranslucentItemStackModelGUI(ItemStack stack, MatrixStack renderStack, Color overlayColor, Blending blendMode, int alpha) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(AtlasTexture.field_110575_b);
        textureManager.func_229267_b_(AtlasTexture.field_110575_b).setBlurMipmap(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        blendMode.apply();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderStack.func_227860_a_();
        renderStack.func_227861_a_(8.0, 8.0, 0.0);
        renderStack.func_227862_a_(16.0f, -16.0f, 16.0f);
        IBakedModel bakedModel = ForgeHooksClient.handleCameraTransforms((MatrixStack)renderStack, (IBakedModel)RenderingUtils.getItemModel(stack), (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        boolean isSideLit = bakedModel.func_230044_c_();
        if (!isSideLit) {
            RenderHelper.func_227783_c_();
        }
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderingUtils.renderItemModelWithColor(stack, ItemCameraTransforms.TransformType.GUI, bakedModel, renderStack, (IRenderTypeBuffer)buffer, LightmapUtil.getPackedFullbrightCoords(), OverlayTexture.field_229196_a_, overlayColor, MathHelper.func_76125_a((int)alpha, (int)0, (int)255));
        buffer.func_228461_a_();
        if (!isSideLit) {
            RenderHelper.func_227784_d_();
        }
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.enableDepthTest();
        renderStack.func_227865_b_();
    }

    @Deprecated
    public static void mcdefault_renderItemOverlayIntoGUI(FontRenderer fr, MatrixStack renderStack, ItemStack stack, float pTicks, @Nullable String text) {
        ClientPlayerEntity player;
        float cooldownPercent;
        if (stack.func_190926_b()) {
            return;
        }
        RenderSystem.disableLighting();
        renderStack.func_227860_a_();
        renderStack.func_227861_a_(0.0, 0.0, 100.0);
        if (stack.func_190916_E() > 1 || text != null) {
            StringTextComponent display = new StringTextComponent((String)ObjectUtils.firstNonNull((Object[])new String[]{text, String.valueOf(stack.func_190916_E())}));
            int length = fr.func_238414_a_((ITextProperties)display);
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)(17 - length), 9.0, 0.0);
            RenderingDrawUtils.renderStringAt((ITextProperties)display, renderStack, fr, -1, true);
            renderStack.func_227865_b_();
        }
        if (stack.func_77973_b().showDurabilityBar(stack)) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.disableAlphaTest();
            RenderSystem.disableBlend();
            float health = (float)stack.func_77973_b().getDurabilityForDisplay(stack);
            float durabilityPercent = 13.0f - health * 13.0f;
            int color = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
            RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, (BufferBuilder buf) -> {
                RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, 2.0f, 13.0f, 0.0f, 13.0f, 2.0f).color(0, 0, 0, 255).draw();
                RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, 2.0f, 13.0f, 0.0f, durabilityPercent, 1.0f).color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255).draw();
            });
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
            RenderSystem.enableDepthTest();
        }
        float f = cooldownPercent = (player = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : player.func_184811_cZ().func_185143_a(stack.func_77973_b(), pTicks);
        if (cooldownPercent > 0.0f) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, (BufferBuilder buf) -> RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, 0.0f, 16.0f * (1.0f - cooldownPercent), 0.0f, 16.0f, 16.0f * cooldownPercent).color(255, 255, 255, 127).draw());
            RenderSystem.enableTexture();
            RenderSystem.enableDepthTest();
        }
        renderStack.func_227865_b_();
    }

    private static IBakedModel getItemModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, (World)Minecraft.func_71410_x().field_71441_e, (LivingEntity)Minecraft.func_71410_x().field_71439_g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderItemModelWithColor(ItemStack stack, ItemCameraTransforms.TransformType transformType, IBakedModel model, MatrixStack renderStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, Color c, int alpha) {
        if (!stack.func_190926_b()) {
            boolean renderThirdPersonView;
            renderStack.func_227860_a_();
            renderStack.func_227861_a_(-0.5, -0.5, -0.5);
            boolean bl = renderThirdPersonView = transformType == ItemCameraTransforms.TransformType.GUI || transformType == ItemCameraTransforms.TransformType.GROUND || transformType == ItemCameraTransforms.TransformType.FIXED;
            if (model.func_188618_c() || stack.func_77973_b() == Items.field_203184_eO && !renderThirdPersonView) {
                int[] colors = new int[]{c.getRed(), c.getGreen(), c.getBlue(), alpha};
                IRenderTypeBuffer decoratedBuffer = type -> BufferDecoratorBuilder.withColor((r, g, b, a) -> colors).decorate(buffer.getBuffer(type));
                stack.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(stack, transformType, renderStack, decoratedBuffer, combinedLight, combinedOverlay);
            } else if (model.isLayered()) {
                for (Pair layerModel : model.getLayerModels(stack, true)) {
                    IBakedModel layer = (IBakedModel)layerModel.getFirst();
                    RenderType rType = (RenderType)layerModel.getSecond();
                    ForgeHooksClient.setRenderLayer((RenderType)rType);
                    try {
                        IVertexBuilder vertexBuilder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)buffer, (RenderType)rType, (boolean)true, (boolean)stack.func_77962_s());
                        RenderingUtils.renderColoredItemModel(stack, layer, renderStack, vertexBuilder, combinedLight, combinedOverlay, c, alpha);
                    }
                    finally {
                        ForgeHooksClient.setRenderLayer(null);
                    }
                }
            } else {
                IVertexBuilder vertexBuilder;
                RenderType rType = RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)true);
                if (stack.func_77973_b() instanceof CompassItem && stack.func_77962_s()) {
                    renderStack.func_227860_a_();
                    MatrixStack.Entry topEntry = renderStack.func_227866_c_();
                    if (transformType == ItemCameraTransforms.TransformType.GUI) {
                        topEntry.func_227870_a_().func_226592_a_(0.5f);
                    } else if (transformType.func_241716_a_()) {
                        topEntry.func_227870_a_().func_226592_a_(0.75f);
                    }
                    vertexBuilder = ItemRenderer.func_241732_b_((IRenderTypeBuffer)buffer, (RenderType)rType, (MatrixStack.Entry)topEntry);
                    renderStack.func_227865_b_();
                } else {
                    vertexBuilder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)buffer, (RenderType)rType, (boolean)true, (boolean)stack.func_77962_s());
                }
                RenderingUtils.renderColoredItemModel(stack, model, renderStack, vertexBuilder, combinedLight, combinedOverlay, c, alpha);
            }
            renderStack.func_227865_b_();
        }
    }

    private static void renderColoredItemModel(ItemStack stack, IBakedModel model, MatrixStack renderStack, IVertexBuilder buffer, int combinedLight, int combinedOverlay, Color color, int alpha) {
        Color alphaColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        Random renderRand = new Random();
        EmptyModelData data = EmptyModelData.INSTANCE;
        for (Direction dir : Direction.values()) {
            renderRand.setSeed(42L);
            RenderingUtils.renderColoredQuads(buffer, renderStack, model.getQuads(null, dir, renderRand, (IModelData)data), alphaColor, combinedLight, combinedOverlay, stack);
        }
        renderRand.setSeed(42L);
        RenderingUtils.renderColoredQuads(buffer, renderStack, model.getQuads(null, null, renderRand, (IModelData)data), alphaColor, combinedLight, combinedOverlay, stack);
    }

    private static void renderColoredQuads(IVertexBuilder vb, MatrixStack renderStack, List<BakedQuad> quads, Color color, int combinedLight, int combinedOverlay, ItemStack stack) {
        boolean useOverlayColors = (color.getRGB() & 0xFFFFFF) == 0xFFFFFF && !stack.func_190926_b();
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int col = color.getRGB();
            if (useOverlayColors && bakedquad.func_178212_b()) {
                col = itemColors.func_186728_a(stack, bakedquad.func_178211_c());
            }
            float r = (float)(col >> 16 & 0xFF) / 255.0f;
            float g = (float)(col >> 8 & 0xFF) / 255.0f;
            float b = (float)(col & 0xFF) / 255.0f;
            float a = (float)color.getAlpha() / 255.0f;
            vb.addVertexData(renderStack.func_227866_c_(), bakedquad, r, g, b, a, combinedLight, combinedOverlay, true);
        }
    }

    public static void renderSimpleBlockModel(BlockState state, MatrixStack renderStack, IVertexBuilder vb) {
        RenderingUtils.renderSimpleBlockModel(state, renderStack, vb, BlockPos.field_177992_a, null, false);
    }

    public static void renderSimpleBlockModel(BlockState state, MatrixStack renderStack, IVertexBuilder vb, BlockPos pos, @Nullable TileEntity te, boolean checkRenderSide) {
        BlockRenderType brt;
        if (plainRenderWorld == null) {
            plainRenderWorld = new EmptyRenderWorld(() -> (Biome)RegistryUtil.client().getValue(Registry.field_239720_u_, Biomes.field_76772_c));
        }
        if ((brt = state.func_185901_i()) == BlockRenderType.INVISIBLE) {
            return;
        }
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        EmptyModelData data = EmptyModelData.INSTANCE;
        if (te != null) {
            data = te.getModelData();
        }
        brd.renderModel(state, pos, plainRenderWorld, renderStack, vb, checkRenderSide, rand, (IModelData)data);
    }

    public static void renderSimpleBlockModelCurrentWorld(BlockState state, MatrixStack renderStack, IVertexBuilder buf, int combinedOverlayIn) {
        RenderingUtils.renderSimpleBlockModelCurrentWorld(state, renderStack, buf, BlockPos.field_177992_a, null, combinedOverlayIn, false);
    }

    public static void renderSimpleBlockModelCurrentWorld(BlockState state, MatrixStack renderStack, IVertexBuilder buf, BlockPos pos, @Nullable TileEntity te, int combinedOverlayIn, boolean checkRenderSide) {
        BlockRenderType brt = state.func_185901_i();
        if (brt == BlockRenderType.INVISIBLE) {
            return;
        }
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        EmptyModelData data = EmptyModelData.INSTANCE;
        if (te != null) {
            data = te.getModelData();
        }
        if (brt == BlockRenderType.MODEL) {
            IBakedModel model = brd.func_184389_a(state);
            brd.func_175019_b().renderModel((IBlockDisplayReader)Minecraft.func_71410_x().field_71441_e, model, state, pos, renderStack, buf, checkRenderSide, rand, state.func_209533_a(pos), combinedOverlayIn, (IModelData)data);
        }
    }
}

