/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.sky.astral;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.sky.astral.AstralSkyRendererSetup;
import hellfirepvp.astralsorcery.client.util.BatchedVertexList;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.base.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.world.ActiveCelestialsHandler;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.fml.LogicalSide;

@OnlyIn(value=Dist.CLIENT)
public class AstralSkyRenderer
implements ISkyRenderHandler {
    private static final Random RAND = new Random();
    private static final ResourceLocation REF_TEX_MOON_PHASES = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation REF_TEX_SUN = new ResourceLocation("textures/environment/sun.png");
    public static AstralSkyRenderer INSTANCE = new AstralSkyRenderer();
    private final BatchedVertexList sky = new BatchedVertexList(DefaultVertexFormats.field_181705_e);
    private final BatchedVertexList skyHorizon = new BatchedVertexList(DefaultVertexFormats.field_181705_e);
    private final List<StarDrawList> starLists = new LinkedList<StarDrawList>();
    private boolean initialized = false;

    private AstralSkyRenderer() {
    }

    public void reset() {
        this.sky.reset();
        this.skyHorizon.reset();
        this.starLists.forEach(BatchedVertexList::reset);
        this.starLists.clear();
        this.initialized = false;
    }

    private void initialize() {
        this.sky.batch(AstralSkyRendererSetup::generateSky);
        this.skyHorizon.batch(AstralSkyRendererSetup::generateSkyHorizon);
        for (int i = 0; i < 20; ++i) {
            AbstractRenderableTexture starTexture = i % 2 == 0 ? TexturesAS.TEX_STAR_1 : TexturesAS.TEX_STAR_2;
            int flicker = 12 + RAND.nextInt(5);
            StarDrawList starList = new StarDrawList(starTexture, flicker);
            starList.batch(buf -> AstralSkyRendererSetup.generateStars(buf, 60 + RAND.nextInt(60), 1.1f + RAND.nextFloat() * 0.3f));
            this.starLists.add(starList);
        }
        this.initialized = true;
    }

    public void render(int ticks, float pTicks, MatrixStack renderStack, ClientWorld world, Minecraft mc) {
        if (AssetLibrary.isReloading()) {
            return;
        }
        if (!this.initialized) {
            this.initialize();
        }
        Vector3d color = world.func_228318_a_(mc.field_71460_t.func_215316_n().func_216780_d(), pTicks);
        float skyR = (float)color.field_72450_a;
        float skyG = (float)color.field_72448_b;
        float skyB = (float)color.field_72449_c;
        WorldContext ctx = SkyHandler.getContext((World)world, LogicalSide.CLIENT);
        if (ctx != null && ctx.getCelestialEventHandler().getSolarEclipse().isActiveNow()) {
            float perc = ctx.getCelestialEventHandler().getSolarEclipsePercent();
            perc = 0.05f + perc * 0.95f;
            skyR *= perc;
            skyG *= perc;
            skyB *= perc;
        }
        RenderSystem.disableTexture();
        FogRenderer.func_228373_b_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color4f((float)skyR, (float)skyG, (float)skyB, (float)1.0f);
        this.sky.render(renderStack);
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderSystem.shadeModel((int)7425);
        float[] duskDawnColors = world.func_239132_a_().func_230492_a_(world.func_242415_f(pTicks), pTicks);
        if (duskDawnColors != null) {
            this.renderDuskDawn(duskDawnColors, renderStack, world, pTicks);
        }
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableTexture();
        Blending.ADDITIVE_ALPHA.apply();
        renderStack.func_227860_a_();
        renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_242415_f(pTicks) * 360.0f));
        this.renderCelestials(world, renderStack, pTicks);
        this.renderStars(world, renderStack, pTicks);
        renderStack.func_227865_b_();
        renderStack.func_227860_a_();
        renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        AstralSkyRenderer.renderConstellationsSky(world, renderStack, pTicks);
        renderStack.func_227865_b_();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double horizonDiff = Minecraft.func_71410_x().field_71439_g.func_174824_e((float)pTicks).field_72448_b - world.func_72912_H().func_239159_f_();
        if (horizonDiff < 0.0) {
            renderStack.func_227860_a_();
            renderStack.func_227861_a_(0.0, 12.0, 0.0);
            this.skyHorizon.render(renderStack);
            renderStack.func_227865_b_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }

    public static void renderConstellationsSky(ClientWorld world, MatrixStack renderStack, float pTicks) {
        WorldContext ctx = SkyHandler.getContext((World)world, LogicalSide.CLIENT);
        if (ctx == null) {
            return;
        }
        int dayLength = (Integer)GeneralConfig.CONFIG.dayLength.get();
        long wTime = (world.func_72820_D() % (long)dayLength + (long)dayLength) % (long)dayLength;
        if ((float)wTime < (float)dayLength / 2.0f) {
            return;
        }
        float rainDim = 1.0f - world.func_72867_j(pTicks);
        float brightness = world.func_228330_j_(pTicks) * rainDim;
        if (brightness <= 0.0f) {
            return;
        }
        Random gen = ctx.getRandom();
        PlayerProgress clientProgress = ResearchHelper.getClientProgress();
        Map<IConstellation, ActiveCelestialsHandler.RenderPosition> constellations = ctx.getActiveCelestialsHandler().getCurrentRenderPositions();
        for (IConstellation cst : constellations.keySet()) {
            if (!clientProgress.hasConstellationDiscovered(cst) || !ctx.getConstellationHandler().isActiveCurrently(cst, MoonPhase.fromWorld((IWorld)world))) continue;
            ActiveCelestialsHandler.RenderPosition pos = constellations.get(cst);
            RenderingConstellationUtils.renderConstellationSky(cst, renderStack, pos, () -> Float.valueOf(RenderingConstellationUtils.conCFlicker(ClientScheduler.getClientTick(), pTicks, 10 + gen.nextInt(5)) * brightness * 1.25f));
        }
    }

    private void renderStars(ClientWorld world, MatrixStack renderStack, float pTicks) {
        float starBrightness = world.func_228330_j_(pTicks) * (1.0f - world.func_72867_j(pTicks));
        if (starBrightness > 0.0f) {
            this.starLists.forEach(list -> {
                float br = RenderingConstellationUtils.stdFlicker(ClientScheduler.getClientTick(), pTicks, ((StarDrawList)list).flickerSpeed) * starBrightness;
                RenderSystem.color4f((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)br);
                list.render(renderStack);
            });
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderCelestials(ClientWorld world, MatrixStack renderStack, float pTicks) {
        WorldContext ctx = SkyHandler.getContext((World)world, LogicalSide.CLIENT);
        float rainAlpha = 1.0f - world.func_72867_j(pTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)rainAlpha);
        if (ctx != null && ctx.getCelestialEventHandler().getSolarEclipse().isActiveNow()) {
            this.renderSolarEclipseSun(renderStack, ctx);
        } else {
            this.renderSun(renderStack);
        }
        if (ctx != null && ctx.getCelestialEventHandler().getLunarEclipse().isActiveNow()) {
            int lunarHalf = ctx.getCelestialEventHandler().getLunarEclipse().getEventDuration() / 2;
            float eclTick = ctx.getCelestialEventHandler().getLunarEclipse().getEffectTick(0.0f);
            eclTick = eclTick >= (float)lunarHalf ? (eclTick -= (float)lunarHalf) : (float)lunarHalf - eclTick;
            float perc = eclTick / (float)lunarHalf;
            RenderSystem.color4f((float)1.0f, (float)(0.4f + 0.6f * perc), (float)(0.4f + 0.6f * perc), (float)rainAlpha);
            this.renderMoon(renderStack, (World)world);
        } else {
            this.renderMoon(renderStack, (World)world);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderSolarEclipseSun(MatrixStack renderStack, WorldContext ctx) {
        float sunSize = 30.0f;
        float eclipseTick = ctx.getCelestialEventHandler().getSolarEclipse().getEffectTick(0.0f);
        float part = (float)ctx.getCelestialEventHandler().getSolarEclipse().getEventDuration() / 7.0f;
        float u = 0.0f;
        float tick = eclipseTick;
        while (tick - part > 0.0f) {
            tick -= part;
            u += 1.0f;
        }
        float uOffset = u;
        TexturesAS.TEX_SOLAR_ECLIPSE.bindTexture();
        renderStack.func_227860_a_();
        renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        RenderingUtils.draw(7, DefaultVertexFormats.field_181707_g, buf -> {
            buf.func_227888_a_(matr, -sunSize, 100.0f, -sunSize).func_225583_a_(uOffset / 7.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(matr, sunSize, 100.0f, -sunSize).func_225583_a_((uOffset + 1.0f) / 7.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(matr, sunSize, 100.0f, sunSize).func_225583_a_((uOffset + 1.0f) / 7.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(matr, -sunSize, 100.0f, sunSize).func_225583_a_(uOffset / 7.0f, 1.0f).func_181675_d();
        });
        renderStack.func_227865_b_();
    }

    private void renderSun(MatrixStack renderStack) {
        float sunSize = 30.0f;
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(REF_TEX_SUN);
        RenderingUtils.draw(7, DefaultVertexFormats.field_181707_g, buf -> {
            buf.func_227888_a_(matr, -sunSize, 100.0f, -sunSize).func_225583_a_(0.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(matr, sunSize, 100.0f, -sunSize).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(matr, sunSize, 100.0f, sunSize).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(matr, -sunSize, 100.0f, sunSize).func_225583_a_(0.0f, 1.0f).func_181675_d();
        });
    }

    private void renderMoon(MatrixStack renderStack, World world) {
        float moonSize = 20.0f;
        int moonPhase = world.func_242414_af();
        int i = moonPhase % 4;
        int j = moonPhase / 4 % 2;
        float minU = (float)i / 4.0f;
        float minV = (float)j / 2.0f;
        float maxU = (float)(i + 1) / 4.0f;
        float maxV = (float)(j + 1) / 2.0f;
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(REF_TEX_MOON_PHASES);
        RenderingUtils.draw(7, DefaultVertexFormats.field_181707_g, buf -> {
            buf.func_227888_a_(matr, -moonSize, -100.0f, moonSize).func_225583_a_(maxU, maxV).func_181675_d();
            buf.func_227888_a_(matr, moonSize, -100.0f, moonSize).func_225583_a_(minU, maxV).func_181675_d();
            buf.func_227888_a_(matr, moonSize, -100.0f, -moonSize).func_225583_a_(minU, minV).func_181675_d();
            buf.func_227888_a_(matr, -moonSize, -100.0f, -moonSize).func_225583_a_(maxU, minV).func_181675_d();
        });
    }

    private void renderDuskDawn(float[] duskDawnColors, MatrixStack renderStack, ClientWorld world, float pTicks) {
        float f3 = MathHelper.func_76126_a((float)world.func_72929_e(pTicks)) < 0.0f ? 180.0f : 0.0f;
        renderStack.func_227860_a_();
        renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        renderStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
        renderStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        float r = duskDawnColors[0];
        float g = duskDawnColors[1];
        float b = duskDawnColors[2];
        float a = duskDawnColors[3];
        RenderingUtils.draw(6, DefaultVertexFormats.field_181706_f, buf -> {
            buf.func_225582_a_(0.0, 100.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
            for (int i = 0; i <= 16; ++i) {
                float f6 = (float)i * ((float)Math.PI * 2) / 16.0f;
                float f7 = MathHelper.func_76126_a((float)f6);
                float f8 = MathHelper.func_76134_b((float)f6);
                buf.func_225582_a_((double)(f7 * 120.0f), (double)(f8 * 120.0f), (double)(-f8 * 40.0f * a)).func_227885_a_(r, g, b, 0.0f).func_181675_d();
            }
        });
        renderStack.func_227865_b_();
    }

    private static class StarDrawList
    extends BatchedVertexList {
        private final AbstractRenderableTexture texture;
        private final int flickerSpeed;

        private StarDrawList(AbstractRenderableTexture texture, int flickerSpeed) {
            super(DefaultVertexFormats.field_181707_g);
            this.texture = texture;
            this.flickerSpeed = flickerSpeed;
        }

        @Override
        public void render(MatrixStack renderStack) {
            this.texture.bindTexture();
            super.render(renderStack);
        }
    }
}

