/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.helper;

import hellfirepvp.astralsorcery.client.screen.base.WidthHeightScreen;
import hellfirepvp.astralsorcery.client.screen.helper.ScalingPoint;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;

public abstract class SizeHandler {
    private static final int W_H_NODE = 18;
    private float widthHeightNodes = 18.0f;
    private float spaceBetweenNodes = 18.0f;
    private float shiftX;
    private float shiftY;
    private float leftOffset;
    private float topOffset;
    private float totalWidth;
    private float totalHeight;
    private float scalingFactor = 1.0f;
    private float maxScale = 10.0f;
    private float minScale = 1.0f;
    private float scaleSpeed = 0.2f;

    public void setMaxScale(float maxScale) {
        this.maxScale = maxScale;
    }

    public void setScaleSpeed(float scaleSpeed) {
        this.scaleSpeed = scaleSpeed;
    }

    public void setMinScale(float minScale) {
        this.minScale = minScale;
    }

    public void setWidthHeightNodes(float widthHeightNodes) {
        this.widthHeightNodes = widthHeightNodes;
    }

    public void setSpaceBetweenNodes(float spaceBetweenNodes) {
        this.spaceBetweenNodes = spaceBetweenNodes;
    }

    public void updateSize() {
        this.resetZoom();
        float leftMost = 0.0f;
        float rightMost = 0.0f;
        float upperMost = 0.0f;
        float lowerMost = 0.0f;
        float[] requiredRect = this.buildRequiredRectangle();
        if (requiredRect != null) {
            leftMost = requiredRect[0];
            rightMost = requiredRect[1];
            upperMost = requiredRect[2];
            lowerMost = requiredRect[3];
        }
        this.shiftX = (leftMost + rightMost) / 2.0f;
        this.shiftY = (lowerMost + upperMost) / 2.0f;
        float width = rightMost - leftMost;
        float height = lowerMost - upperMost;
        this.leftOffset = leftMost - this.shiftX;
        this.topOffset = upperMost - this.shiftY;
        this.totalWidth = width * this.widthHeightNodes + Math.max(width - 1.0f, 0.0f) * this.spaceBetweenNodes;
        this.totalHeight = height * this.widthHeightNodes + Math.max(height - 1.0f, 0.0f) * this.spaceBetweenNodes;
    }

    @Nullable
    public abstract float[] buildRequiredRectangle();

    public float getTotalWidth() {
        return this.totalWidth * this.scalingFactor;
    }

    public float getTotalHeight() {
        return this.totalHeight * this.scalingFactor;
    }

    public Point2D.Float getRelativeCenter() {
        return new Point2D.Float(this.getTotalWidth() / 2.0f, this.getTotalHeight() / 2.0f);
    }

    public float getScalingFactor() {
        return this.scalingFactor;
    }

    public float getZoomedWHNode() {
        return this.widthHeightNodes * this.scalingFactor;
    }

    public float getZoomedSpaceBetweenNodes() {
        return this.spaceBetweenNodes * this.scalingFactor;
    }

    public float scaleAccordingly(float toScale) {
        return toScale * this.scalingFactor;
    }

    public void handleZoomIn() {
        if (this.scalingFactor >= this.maxScale) {
            return;
        }
        this.scalingFactor = Math.min(this.maxScale, this.scalingFactor + this.scaleSpeed);
    }

    public void handleZoomOut() {
        if (this.scalingFactor <= this.minScale) {
            return;
        }
        this.scalingFactor = Math.max(this.minScale, this.scalingFactor - this.scaleSpeed);
    }

    public void forceScaleTo(float scale) {
        this.scalingFactor = scale;
    }

    public void resetZoom() {
        this.scalingFactor = 1.0f;
    }

    public float clampX(float centerX) {
        return MathHelper.func_76131_a((float)centerX, (float)0.0f, (float)this.getTotalWidth());
    }

    public float clampY(float centerY) {
        return MathHelper.func_76131_a((float)centerY, (float)0.0f, (float)this.getTotalHeight());
    }

    public float evRelativePosX(float relativeX) {
        float shiftedX = relativeX - this.shiftX;
        float leftShift = shiftedX - this.leftOffset;
        float offsetX = leftShift * (this.getZoomedWHNode() + this.getZoomedSpaceBetweenNodes());
        return offsetX += 0.5f * this.getZoomedWHNode();
    }

    public float evRelativePosY(float relativeY) {
        float shiftedY = relativeY - this.shiftY;
        float topShift = shiftedY - this.topOffset;
        float offsetY = topShift * (this.getZoomedWHNode() + this.getZoomedSpaceBetweenNodes());
        return offsetY += 0.5f * this.getZoomedWHNode();
    }

    public Point2D.Float evRelativePos(Point2D.Float offset) {
        return new Point2D.Float(this.evRelativePosX(offset.x), this.evRelativePosY(offset.y));
    }

    public Point2D.Float evRelativePos(Point offset) {
        return new Point2D.Float(this.evRelativePosX(offset.x), this.evRelativePosY(offset.y));
    }

    public float scaledDistanceX(float fromX, float toX) {
        return this.evRelativePosX(toX) - this.evRelativePosX(fromX);
    }

    public float scaledDistanceY(float fromY, float toY) {
        return this.evRelativePosY(toY) - this.evRelativePosY(fromY);
    }

    public Point2D.Float scalePointToGui(WidthHeightScreen screen, ScalingPoint currentOffset, Point2D.Float point) {
        Point2D.Float shifted = this.evRelativePos(point);
        float fX = shifted.x - currentOffset.getScaledPosX() + (float)screen.getGuiLeft() + (float)screen.getGuiWidth() / 2.0f;
        float fY = shifted.y - currentOffset.getScaledPosY() + (float)screen.getGuiTop() + (float)screen.getGuiHeight() / 2.0f;
        return new Point2D.Float(fX, fY);
    }
}

