/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.function;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public interface VFXMotionController<T extends EntityVisualFX> {
    public static final VFXMotionController<?> IDENTITY = (fx, motion) -> motion;

    public static <T extends EntityVisualFX> VectorTarget<T> target(Supplier<Vector3> targetSupplier) {
        return VFXMotionController.target(targetSupplier, 0.1f);
    }

    public static <T extends EntityVisualFX> VectorTarget<T> target(Supplier<Vector3> targetSupplier, float velocityMultiplier) {
        return new VectorTarget(targetSupplier, velocityMultiplier);
    }

    public static <T extends EntityVisualFX> VFXMotionController<T> accelerate(final Supplier<Vector3> originalMotion) {
        return new VFXMotionController<T>(){

            @Override
            @Nonnull
            public Vector3 updateMotion(@Nonnull T fx, @Nonnull Vector3 motion) {
                float perc = (float)((EntityComplexFX)fx).getAge() / (float)((EntityComplexFX)fx).getMaxAge();
                return ((Vector3)originalMotion.get()).clone().multiply(perc);
            }
        };
    }

    public static <T extends EntityVisualFX> VFXMotionController<T> decelerate(final Supplier<Vector3> originalMotion) {
        return new VFXMotionController<T>(){

            @Override
            @Nonnull
            public Vector3 updateMotion(@Nonnull T fx, @Nonnull Vector3 motion) {
                float perc = 1.0f - (float)((EntityComplexFX)fx).getAge() / (float)((EntityComplexFX)fx).getMaxAge();
                return ((Vector3)originalMotion.get()).clone().multiply(perc);
            }
        };
    }

    @Nonnull
    public Vector3 updateMotion(@Nonnull T var1, @Nonnull Vector3 var2);

    public static class VectorTarget<T extends EntityVisualFX>
    implements VFXMotionController<T> {
        private final Supplier<Vector3> positionSupplier;
        private final float velocityMultiplier;

        protected VectorTarget(Supplier<Vector3> positionSupplier, float velocityMultiplier) {
            this.positionSupplier = positionSupplier;
            this.velocityMultiplier = velocityMultiplier;
        }

        @Override
        @Nonnull
        public Vector3 updateMotion(@Nonnull T fx, @Nonnull Vector3 motion) {
            Vector3 target = this.positionSupplier.get();
            if (target == null) {
                return motion;
            }
            EntityUtils.applyVortexMotion(() -> fx.getPosition(), motion::add, target, 256.0, this.velocityMultiplier);
            return motion.multiply(0.9);
        }
    }
}

