/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.item;

import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.integration.IntegrationBotania;
import hellfirepvp.astralsorcery.common.util.item.ItemComparator;
import hellfirepvp.astralsorcery.common.util.tile.TileInventory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ItemUtils {
    public static final IItemHandler EMPTY_INVENTORY = new ItemHandlerEmpty();
    private static final Random rand = new Random();

    public static ItemEntity dropItem(World world, double x, double y, double z, ItemStack stack) {
        if (world.field_72995_K) {
            return null;
        }
        ItemEntity ei = new ItemEntity(world, x, y, z, stack);
        ei.func_213317_d(new Vector3d(0.0, 0.0, 0.0));
        world.func_217376_c((Entity)ei);
        ei.func_174867_a(20);
        return ei;
    }

    public static ItemEntity dropItemNaturally(World world, double x, double y, double z, ItemStack stack) {
        if (world.field_72995_K) {
            return null;
        }
        ItemEntity ei = new ItemEntity(world, x, y, z, stack);
        ItemUtils.applyRandomDropOffset(ei);
        world.func_217376_c((Entity)ei);
        ei.func_174867_a(20);
        return ei;
    }

    public static void decrementItem(TileInventory inventory, int slot, Consumer<ItemStack> handleExcess) {
        ItemUtils.decrementItem(() -> inventory.getStackInSlot(slot), stack -> inventory.setStackInSlot(slot, (ItemStack)stack), handleExcess);
    }

    public static void decrementItem(Supplier<ItemStack> getFromInventory, Consumer<ItemStack> setIntoInventory, Consumer<ItemStack> handleExcess) {
        ItemStack toConsume = getFromInventory.get();
        toConsume = ItemUtils.copyStackWithSize(toConsume, toConsume.func_190916_E());
        ItemStack toReplaceWith = ItemStack.field_190927_a;
        if (toConsume.hasContainerItem()) {
            toReplaceWith = toConsume.getContainerItem();
        }
        toConsume.func_190918_g(1);
        if (!toReplaceWith.func_190926_b()) {
            if (toConsume.func_190926_b()) {
                setIntoInventory.accept(toReplaceWith);
            } else if (ItemComparator.compare(toConsume, toReplaceWith, ItemComparator.Clause.Sets.ITEMSTACK_STRICT_NOAMOUNT)) {
                toReplaceWith.func_190917_f(toConsume.func_190916_E());
                if (toReplaceWith.func_190916_E() > toReplaceWith.func_77976_d()) {
                    int overcapped = toReplaceWith.func_190916_E() - toReplaceWith.func_77976_d();
                    setIntoInventory.accept(ItemUtils.copyStackWithSize(toReplaceWith, toReplaceWith.func_77976_d()));
                    handleExcess.accept(ItemUtils.copyStackWithSize(toReplaceWith, overcapped));
                } else {
                    setIntoInventory.accept(toReplaceWith);
                }
            } else {
                handleExcess.accept(toReplaceWith);
            }
        } else {
            setIntoInventory.accept(toConsume);
        }
    }

    public static boolean isEquippableArmor(Entity entity, ItemStack stack) {
        for (EquipmentSlotType type : EquipmentSlotType.values()) {
            if (type.func_188453_a() != EquipmentSlotType.Group.ARMOR || !stack.canEquip(type, entity)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack dropItemToPlayer(PlayerEntity player, ItemStack stack) {
        World world = player.func_130014_f_();
        if (world.func_201670_d() || stack.func_190926_b()) {
            return stack;
        }
        ItemEntity item = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
        if (item.func_92059_d().func_190926_b()) {
            return stack;
        }
        item.func_174868_q();
        try {
            item.func_70100_b_(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (item.func_70089_S()) {
            return item.func_92059_d().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private static void applyRandomDropOffset(ItemEntity item) {
        item.func_213293_j((double)(rand.nextFloat() * 0.3f) - 0.15, (double)(rand.nextFloat() * 0.3f) - 0.05, (double)(rand.nextFloat() * 0.3f) - 0.15);
    }

    @Nonnull
    public static ItemStack changeItem(@Nonnull ItemStack stack, @Nonnull Item item) {
        CompoundNBT nbt = stack.func_77955_b(new CompoundNBT());
        nbt.func_74778_a("id", item.getRegistryName().toString());
        return ItemStack.func_199557_a((CompoundNBT)nbt);
    }

    @Nonnull
    public static ItemStack createBlockStack(BlockState state) {
        return new ItemStack((IItemProvider)state.func_177230_c());
    }

    @Nullable
    public static BlockState createBlockState(ItemStack stack) {
        Block b = Block.func_149634_a((Item)stack.func_77973_b());
        if (b == Blocks.field_150350_a) {
            return null;
        }
        return b.func_176223_P();
    }

    @Nonnull
    public static List<ItemStack> getItemsOfTag(ResourceLocation key) {
        ITag tag = ItemTags.func_199903_a().func_199910_a(key);
        return tag == null ? Collections.emptyList() : ItemUtils.getItemsOfTag((ITag<Item>)tag);
    }

    @Nonnull
    public static List<ItemStack> getItemsOfTag(ITag<Item> itemTag) {
        return itemTag.func_230236_b_().stream().map(ItemStack::new).collect(Collectors.toList());
    }

    public static Collection<ItemStack> scanInventoryFor(IItemHandler handler, Item i) {
        LinkedList<ItemStack> out = new LinkedList<ItemStack>();
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (s.func_190926_b() || s.func_77973_b() != i) continue;
            out.add(ItemUtils.copyStackWithSize(s, s.func_190916_E()));
        }
        return out;
    }

    public static Collection<ItemStack> scanInventoryForMatching(IItemHandler handler, ItemStack match, boolean strict) {
        return ItemUtils.findItemsInInventory(handler, match, strict);
    }

    public static Collection<ItemStack> findItemsInPlayerInventory(PlayerEntity player, ItemStack match, boolean strict) {
        IItemHandler handler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)EMPTY_INVENTORY);
        Collection<ItemStack> results = ItemUtils.findItemsInInventory(handler, match, strict);
        if (Mods.BOTANIA.isPresent()) {
            results.addAll(IntegrationBotania.findProvidersProvidingItems(player, match));
        }
        return results;
    }

    public static Collection<ItemStack> findItemsInInventory(IItemHandler handler, ItemStack match, boolean strict) {
        LinkedList<ItemStack> stacksOut = new LinkedList<ItemStack>();
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (!(strict ? ItemComparator.compare(s, match, ItemComparator.Clause.ITEM, ItemComparator.Clause.NBT_STRICT, ItemComparator.Clause.CAPABILITIES_COMPATIBLE) : ItemComparator.compare(s, match, ItemComparator.Clause.ITEM))) continue;
            stacksOut.add(ItemUtils.copyStackWithSize(s, s.func_190916_E()));
        }
        return stacksOut;
    }

    public static Map<Integer, ItemStack> findItemsIndexedInPlayerInventory(PlayerEntity player, Predicate<ItemStack> match) {
        return ItemUtils.findItemsIndexedInInventory((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)EMPTY_INVENTORY), match);
    }

    public static Map<Integer, ItemStack> findItemsIndexedInInventory(IItemHandler handler, ItemStack match, boolean strict) {
        return ItemUtils.findItemsIndexedInInventory(handler, s -> strict ? ItemComparator.compare(s, match, ItemComparator.Clause.ITEM, ItemComparator.Clause.NBT_STRICT, ItemComparator.Clause.CAPABILITIES_COMPATIBLE) : ItemComparator.compare(s, match, ItemComparator.Clause.ITEM));
    }

    public static Map<Integer, ItemStack> findItemsIndexedInInventory(IItemHandler handler, Predicate<ItemStack> match) {
        HashMap<Integer, ItemStack> stacksOut = new HashMap<Integer, ItemStack>();
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (!match.test(s)) continue;
            stacksOut.put(j, ItemUtils.copyStackWithSize(s, s.func_190916_E()));
        }
        return stacksOut;
    }

    public static boolean consumeFromPlayerInventory(PlayerEntity player, ItemStack requestingItemStack, ItemStack toConsume, boolean simulate) {
        int consumed = 0;
        ItemStack tryConsume = ItemUtils.copyStackWithSize(toConsume, toConsume.func_190916_E() - consumed);
        if (tryConsume.func_190926_b()) {
            return true;
        }
        IItemHandlerModifiable handler = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse((Object)EMPTY_INVENTORY);
        if (ItemUtils.consumeFromInventory(handler, tryConsume, simulate)) {
            return true;
        }
        return Mods.BOTANIA.isPresent() && IntegrationBotania.consumeFromPlayerInventory(player, requestingItemStack, toConsume, simulate);
    }

    public static boolean tryConsumeFromInventory(IItemHandler handler, ItemStack toConsume, boolean simulate) {
        return handler instanceof IItemHandlerModifiable && ItemUtils.consumeFromInventory((IItemHandlerModifiable)handler, toConsume, simulate);
    }

    public static boolean consumeFromInventory(IItemHandlerModifiable handler, ItemStack toConsume, boolean simulate) {
        Map<Integer, ItemStack> contents = ItemUtils.findItemsIndexedInInventory((IItemHandler)handler, toConsume, false);
        if (contents.isEmpty()) {
            return false;
        }
        int cAmt = toConsume.func_190916_E();
        for (int slot : contents.keySet()) {
            ItemStack inSlot = contents.get(slot);
            int toRemove = cAmt > inSlot.func_190916_E() ? inSlot.func_190916_E() : cAmt;
            cAmt -= toRemove;
            if (!simulate) {
                handler.setStackInSlot(slot, ItemUtils.copyStackWithSize(inSlot, inSlot.func_190916_E() - toRemove));
            }
            if (cAmt > 0) continue;
            break;
        }
        return cAmt <= 0;
    }

    public static void dropInventory(IItemHandler handle, World worldIn, BlockPos pos) {
        if (worldIn.field_72995_K) {
            return;
        }
        for (int i = 0; i < handle.getSlots(); ++i) {
            ItemStack stack = handle.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        }
    }

    public static void decrStackInInventory(ItemStackHandler handler, int slot) {
        if (slot < 0 || slot >= handler.getSlots()) {
            return;
        }
        ItemStack st = handler.getStackInSlot(slot);
        if (st.func_190926_b()) {
            return;
        }
        st.func_190920_e(st.func_190916_E() - 1);
        if (st.func_190916_E() <= 0) {
            handler.setStackInSlot(slot, ItemStack.field_190927_a);
        }
    }

    public static boolean tryPlaceItemInInventory(@Nonnull ItemStack stack, IItemHandler handler) {
        return ItemUtils.tryPlaceItemInInventory(stack, handler, 0, handler.getSlots());
    }

    public static boolean tryPlaceItemInInventory(@Nonnull ItemStack stack, IItemHandler handler, int start, int end) {
        ItemStack toAdd = stack.func_77946_l();
        if (!ItemUtils.hasInventorySpace(toAdd, handler, start, end)) {
            return false;
        }
        int max = stack.func_77976_d();
        for (int i = start; i < end; ++i) {
            ItemStack in = handler.getStackInSlot(i);
            if (in.func_190926_b()) {
                int added = Math.min(stack.func_190916_E(), max);
                stack.func_190920_e(stack.func_190916_E() - added);
                handler.insertItem(i, ItemUtils.copyStackWithSize(stack, added), false);
                return true;
            }
            if (!ItemComparator.compare(stack, in, ItemComparator.Clause.ITEM, ItemComparator.Clause.NBT_STRICT, ItemComparator.Clause.CAPABILITIES_COMPATIBLE)) continue;
            int space = max - in.func_190916_E();
            int added = Math.min(stack.func_190916_E(), space);
            stack.func_190920_e(stack.func_190916_E() - added);
            handler.getStackInSlot(i).func_190920_e(handler.getStackInSlot(i).func_190916_E() + added);
            if (stack.func_190916_E() > 0) continue;
            return true;
        }
        return stack.func_190916_E() == 0;
    }

    public static boolean hasInventorySpace(@Nonnull ItemStack stack, IItemHandler handler, int rangeMin, int rangeMax) {
        int size = stack.func_190916_E();
        int max = stack.func_77976_d();
        for (int i = rangeMin; i < rangeMax && size > 0; ++i) {
            ItemStack in = handler.getStackInSlot(i);
            if (in.func_190926_b()) {
                size -= max;
                continue;
            }
            if (!ItemComparator.compare(stack, in, ItemComparator.Clause.ITEM, ItemComparator.Clause.NBT_STRICT, ItemComparator.Clause.CAPABILITIES_COMPATIBLE)) continue;
            int space = max - in.func_190916_E();
            size -= space;
        }
        return size <= 0;
    }

    public static ItemStack copyStackWithSize(@Nonnull ItemStack stack, int amount) {
        if (stack.func_190926_b() || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack s = stack.func_77946_l();
        s.func_190920_e(amount);
        return s;
    }

    private static class ItemHandlerEmpty
    implements IItemHandlerModifiable {
        private ItemHandlerEmpty() {
        }

        public int getSlots() {
            return 0;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }
    }
}

