/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void parseMultipleStrings(JsonObject root, String key, Consumer<String> consumer) {
        JsonHelper.consumeJsonListConfiguration(root, key, "String", "Strings", JsonElement::isJsonPrimitive, JsonElement::getAsString, consumer);
    }

    public static void parseMultipleJsonPrimitives(JsonObject root, String key, String singular, String plural, Consumer<JsonPrimitive> consumer) {
        JsonHelper.consumeJsonListConfiguration(root, key, singular, plural, JsonElement::isJsonPrimitive, JsonElement::getAsJsonPrimitive, consumer);
    }

    public static void parseMultipleJsonObjects(JsonObject root, String key, Consumer<JsonObject> consumer) {
        JsonHelper.consumeJsonListConfiguration(root, key, "JsonObject", "JsonObjects", JsonElement::isJsonObject, JsonElement::getAsJsonObject, consumer);
    }

    private static <T> void consumeJsonListConfiguration(JsonObject root, String key, String singular, String plural, Predicate<JsonElement> verifier, Function<JsonElement, T> consumerTransformer, Consumer<T> consumer) {
        if (!root.has(key)) {
            throw new JsonSyntaxException(String.format("Expected '%s' to be a %s or an array of %s!", key, singular, plural));
        }
        JsonElement el = root.get(key);
        if (verifier.test(el)) {
            consumer.accept(consumerTransformer.apply(el));
        } else if (el.isJsonArray()) {
            JsonArray objectArray = el.getAsJsonArray();
            for (JsonElement arrayEl : objectArray) {
                if (!verifier.test(arrayEl)) {
                    throw new JsonSyntaxException(String.format("Expected '%s' to be an array of %s!", key, plural));
                }
                consumer.accept(consumerTransformer.apply(arrayEl));
            }
        } else {
            throw new JsonSyntaxException(String.format("Expected '%s' to be a %s or an array of %s!", key, singular, plural));
        }
    }

    @Nonnull
    public static FluidStack getFluidStack(JsonElement fluidElement, String infoKey) {
        FluidStack fluidStack;
        if (fluidElement.isJsonPrimitive() && ((JsonPrimitive)fluidElement).isString()) {
            String strKey = fluidElement.getAsString();
            ResourceLocation fluidKey = new ResourceLocation(strKey);
            fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(fluidKey), 1000);
        } else if (fluidElement.isJsonObject()) {
            fluidStack = JsonHelper.getFluidStack(fluidElement.getAsJsonObject(), true);
        } else {
            throw new JsonSyntaxException("Missing " + infoKey + ", expected to find a string or object");
        }
        return fluidStack;
    }

    @Nonnull
    public static FluidStack getFluidStack(JsonObject json, boolean readNBT) {
        String fluidName = JSONUtils.func_151200_h((JsonObject)json, (String)"fluid");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        if (fluid == null || fluid == Fluids.field_204541_a) {
            return FluidStack.EMPTY;
        }
        if (readNBT && json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                CompoundNBT nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(element)) : JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)element, (String)"nbt"));
                CompoundNBT tempRead = new CompoundNBT();
                tempRead.func_218657_a("Tag", (INBT)nbt);
                tempRead.func_74778_a("FluidName", fluidName);
                tempRead.func_74768_a("Amount", JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1000));
                return FluidStack.loadFluidStackFromNBT((CompoundNBT)tempRead);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        return new FluidStack(fluid, JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1000));
    }

    @Nonnull
    public static ItemStack getItemStack(JsonElement itemElement, String infoKey) {
        ItemStack itemstack;
        if (itemElement.isJsonPrimitive() && ((JsonPrimitive)itemElement).isString()) {
            String strKey = itemElement.getAsString();
            ResourceLocation itemKey = new ResourceLocation(strKey);
            itemstack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(itemKey));
        } else if (itemElement.isJsonObject()) {
            itemstack = CraftingHelper.getItemStack((JsonObject)itemElement.getAsJsonObject(), (boolean)true);
        } else {
            throw new JsonSyntaxException("Missing " + infoKey + ", expected to find a string or object");
        }
        return itemstack;
    }

    @Nonnull
    public static ItemStack getItemStack(JsonObject root, String key) {
        ItemStack itemstack;
        if (!JSONUtils.func_151204_g((JsonObject)root, (String)key)) {
            throw new JsonSyntaxException("Missing " + key + ", expected to find a string or object");
        }
        if (root.get(key).isJsonObject()) {
            itemstack = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)root, (String)key), (boolean)true);
        } else {
            String strKey = JSONUtils.func_151200_h((JsonObject)root, (String)key);
            ResourceLocation itemKey = new ResourceLocation(strKey);
            itemstack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(itemKey));
        }
        return itemstack;
    }

    @Nonnull
    public static JsonObject serializeItemStack(ItemStack stack) {
        JsonObject object = new JsonObject();
        object.addProperty("item", stack.func_77973_b().getRegistryName().toString());
        object.addProperty("count", (Number)stack.func_190916_E());
        if (stack.func_77942_o()) {
            object.addProperty("nbt", stack.func_77978_p().toString());
        }
        return object;
    }

    public static Color getColor(JsonObject object, String key) {
        String value = JSONUtils.func_151200_h((JsonObject)object, (String)key);
        if (value.startsWith("0x")) {
            String hexNbr = value.substring(2);
            try {
                return new Color(Integer.parseInt(hexNbr, 16), true);
            }
            catch (NumberFormatException exc) {
                throw new JsonParseException("Expected " + hexNbr + " to be a hexadecimal string!", (Throwable)exc);
            }
        }
        try {
            return new Color(Integer.parseInt(value), true);
        }
        catch (NumberFormatException exc) {
            try {
                return new Color(Integer.parseInt(value, 16), true);
            }
            catch (NumberFormatException e) {
                throw new JsonParseException("Expected " + value + " to be a int or hexadecimal-number!", (Throwable)e);
            }
        }
    }
}

