/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.base.BlockDynamicColor;
import hellfirepvp.astralsorcery.common.block.base.CustomItemBlock;
import hellfirepvp.astralsorcery.common.block.base.template.BlockSlabTemplate;
import hellfirepvp.astralsorcery.common.block.base.template.BlockStairsTemplate;
import hellfirepvp.astralsorcery.common.block.blackmarble.BlockBlackMarbleArch;
import hellfirepvp.astralsorcery.common.block.blackmarble.BlockBlackMarbleBricks;
import hellfirepvp.astralsorcery.common.block.blackmarble.BlockBlackMarbleChiseled;
import hellfirepvp.astralsorcery.common.block.blackmarble.BlockBlackMarbleEngraved;
import hellfirepvp.astralsorcery.common.block.blackmarble.BlockBlackMarblePillar;
import hellfirepvp.astralsorcery.common.block.blackmarble.BlockBlackMarbleRaw;
import hellfirepvp.astralsorcery.common.block.blackmarble.BlockBlackMarbleRuned;
import hellfirepvp.astralsorcery.common.block.foliage.BlockGlowFlower;
import hellfirepvp.astralsorcery.common.block.infusedwood.BlockInfusedWood;
import hellfirepvp.astralsorcery.common.block.infusedwood.BlockInfusedWoodArch;
import hellfirepvp.astralsorcery.common.block.infusedwood.BlockInfusedWoodColumn;
import hellfirepvp.astralsorcery.common.block.infusedwood.BlockInfusedWoodEngraved;
import hellfirepvp.astralsorcery.common.block.infusedwood.BlockInfusedWoodEnriched;
import hellfirepvp.astralsorcery.common.block.infusedwood.BlockInfusedWoodInfused;
import hellfirepvp.astralsorcery.common.block.infusedwood.BlockInfusedWoodPlanks;
import hellfirepvp.astralsorcery.common.block.marble.BlockMarbleArch;
import hellfirepvp.astralsorcery.common.block.marble.BlockMarbleBricks;
import hellfirepvp.astralsorcery.common.block.marble.BlockMarbleChiseled;
import hellfirepvp.astralsorcery.common.block.marble.BlockMarbleEngraved;
import hellfirepvp.astralsorcery.common.block.marble.BlockMarblePillar;
import hellfirepvp.astralsorcery.common.block.marble.BlockMarbleRaw;
import hellfirepvp.astralsorcery.common.block.marble.BlockMarbleRuned;
import hellfirepvp.astralsorcery.common.block.ore.BlockAquamarineSandOre;
import hellfirepvp.astralsorcery.common.block.ore.BlockRockCrystalOre;
import hellfirepvp.astralsorcery.common.block.ore.BlockStarmetal;
import hellfirepvp.astralsorcery.common.block.ore.BlockStarmetalOre;
import hellfirepvp.astralsorcery.common.block.tile.BlockAttunementAltar;
import hellfirepvp.astralsorcery.common.block.tile.BlockCelestialCrystalCluster;
import hellfirepvp.astralsorcery.common.block.tile.BlockCelestialGateway;
import hellfirepvp.astralsorcery.common.block.tile.BlockChalice;
import hellfirepvp.astralsorcery.common.block.tile.BlockFlareLight;
import hellfirepvp.astralsorcery.common.block.tile.BlockFountain;
import hellfirepvp.astralsorcery.common.block.tile.BlockGemCrystalCluster;
import hellfirepvp.astralsorcery.common.block.tile.BlockIlluminator;
import hellfirepvp.astralsorcery.common.block.tile.BlockInfuser;
import hellfirepvp.astralsorcery.common.block.tile.BlockLens;
import hellfirepvp.astralsorcery.common.block.tile.BlockObservatory;
import hellfirepvp.astralsorcery.common.block.tile.BlockPrism;
import hellfirepvp.astralsorcery.common.block.tile.BlockRefractionTable;
import hellfirepvp.astralsorcery.common.block.tile.BlockRitualLink;
import hellfirepvp.astralsorcery.common.block.tile.BlockRitualPedestal;
import hellfirepvp.astralsorcery.common.block.tile.BlockSpectralRelay;
import hellfirepvp.astralsorcery.common.block.tile.BlockStructural;
import hellfirepvp.astralsorcery.common.block.tile.BlockTelescope;
import hellfirepvp.astralsorcery.common.block.tile.BlockTranslucentBlock;
import hellfirepvp.astralsorcery.common.block.tile.BlockTreeBeacon;
import hellfirepvp.astralsorcery.common.block.tile.BlockTreeBeaconComponent;
import hellfirepvp.astralsorcery.common.block.tile.BlockVanishing;
import hellfirepvp.astralsorcery.common.block.tile.BlockWell;
import hellfirepvp.astralsorcery.common.block.tile.altar.BlockAltarAttunement;
import hellfirepvp.astralsorcery.common.block.tile.altar.BlockAltarConstellation;
import hellfirepvp.astralsorcery.common.block.tile.altar.BlockAltarDiscovery;
import hellfirepvp.astralsorcery.common.block.tile.altar.BlockAltarRadiance;
import hellfirepvp.astralsorcery.common.block.tile.crystal.BlockCelestialCollectorCrystal;
import hellfirepvp.astralsorcery.common.block.tile.crystal.BlockRockCollectorCrystal;
import hellfirepvp.astralsorcery.common.block.tile.fountain.BlockFountainPrimeLiquid;
import hellfirepvp.astralsorcery.common.block.tile.fountain.BlockFountainPrimeOre;
import hellfirepvp.astralsorcery.common.block.tile.fountain.BlockFountainPrimeVortex;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.registry.RegistryFluids;
import hellfirepvp.astralsorcery.common.util.NameUtil;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;

public class RegistryBlocks {
    private static final List<BlockDynamicColor> COLOR_BLOCKS = Lists.newArrayList();
    static final List<CustomItemBlock> ITEM_BLOCKS = new LinkedList<CustomItemBlock>();

    private RegistryBlocks() {
    }

    public static void registerBlocks() {
        BlocksAS.MARBLE_ARCH = RegistryBlocks.registerBlock(new BlockMarbleArch());
        BlocksAS.MARBLE_BRICKS = RegistryBlocks.registerBlock(new BlockMarbleBricks());
        BlocksAS.MARBLE_CHISELED = RegistryBlocks.registerBlock(new BlockMarbleChiseled());
        BlocksAS.MARBLE_ENGRAVED = RegistryBlocks.registerBlock(new BlockMarbleEngraved());
        BlocksAS.MARBLE_PILLAR = RegistryBlocks.registerBlock(new BlockMarblePillar());
        BlocksAS.MARBLE_RAW = RegistryBlocks.registerBlock(new BlockMarbleRaw());
        BlocksAS.MARBLE_RUNED = RegistryBlocks.registerBlock(new BlockMarbleRuned());
        BlocksAS.MARBLE_STAIRS = RegistryBlocks.makeStairs(BlocksAS.MARBLE_BRICKS.func_176223_P(), "marble_stairs");
        BlocksAS.MARBLE_SLAB = RegistryBlocks.makeSlab(BlocksAS.MARBLE_BRICKS.func_176223_P(), "marble_slab");
        BlocksAS.BLACK_MARBLE_ARCH = RegistryBlocks.registerBlock(new BlockBlackMarbleArch());
        BlocksAS.BLACK_MARBLE_BRICKS = RegistryBlocks.registerBlock(new BlockBlackMarbleBricks());
        BlocksAS.BLACK_MARBLE_CHISELED = RegistryBlocks.registerBlock(new BlockBlackMarbleChiseled());
        BlocksAS.BLACK_MARBLE_ENGRAVED = RegistryBlocks.registerBlock(new BlockBlackMarbleEngraved());
        BlocksAS.BLACK_MARBLE_PILLAR = RegistryBlocks.registerBlock(new BlockBlackMarblePillar());
        BlocksAS.BLACK_MARBLE_RAW = RegistryBlocks.registerBlock(new BlockBlackMarbleRaw());
        BlocksAS.BLACK_MARBLE_RUNED = RegistryBlocks.registerBlock(new BlockBlackMarbleRuned());
        BlocksAS.BLACK_MARBLE_STAIRS = RegistryBlocks.makeStairs(BlocksAS.BLACK_MARBLE_BRICKS.func_176223_P(), "black_marble_stairs");
        BlocksAS.BLACK_MARBLE_SLAB = RegistryBlocks.makeSlab(BlocksAS.BLACK_MARBLE_BRICKS.func_176223_P(), "black_marble_slab");
        BlocksAS.INFUSED_WOOD = RegistryBlocks.registerBlock(new BlockInfusedWood());
        BlocksAS.INFUSED_WOOD_ARCH = RegistryBlocks.registerBlock(new BlockInfusedWoodArch());
        BlocksAS.INFUSED_WOOD_COLUMN = RegistryBlocks.registerBlock(new BlockInfusedWoodColumn());
        BlocksAS.INFUSED_WOOD_ENGRAVED = RegistryBlocks.registerBlock(new BlockInfusedWoodEngraved());
        BlocksAS.INFUSED_WOOD_ENRICHED = RegistryBlocks.registerBlock(new BlockInfusedWoodEnriched());
        BlocksAS.INFUSED_WOOD_INFUSED = RegistryBlocks.registerBlock(new BlockInfusedWoodInfused());
        BlocksAS.INFUSED_WOOD_PLANKS = RegistryBlocks.registerBlock(new BlockInfusedWoodPlanks());
        BlocksAS.INFUSED_WOOD_STAIRS = RegistryBlocks.makeStairs(BlocksAS.INFUSED_WOOD_PLANKS.func_176223_P(), "infused_wood_stairs");
        BlocksAS.INFUSED_WOOD_SLAB = RegistryBlocks.makeSlab(BlocksAS.INFUSED_WOOD_PLANKS.func_176223_P(), "infused_wood_slab");
        BlocksAS.AQUAMARINE_SAND_ORE = RegistryBlocks.registerBlock(new BlockAquamarineSandOre());
        BlocksAS.ROCK_CRYSTAL_ORE = RegistryBlocks.registerBlock(new BlockRockCrystalOre());
        BlocksAS.STARMETAL_ORE = RegistryBlocks.registerBlock(new BlockStarmetalOre());
        BlocksAS.STARMETAL = RegistryBlocks.registerBlock(new BlockStarmetal());
        BlocksAS.GLOW_FLOWER = RegistryBlocks.registerBlock(new BlockGlowFlower());
        BlocksAS.SPECTRAL_RELAY = RegistryBlocks.registerBlock(new BlockSpectralRelay());
        BlocksAS.ALTAR_DISCOVERY = RegistryBlocks.registerBlock(new BlockAltarDiscovery());
        BlocksAS.ALTAR_ATTUNEMENT = RegistryBlocks.registerBlock(new BlockAltarAttunement());
        BlocksAS.ALTAR_CONSTELLATION = RegistryBlocks.registerBlock(new BlockAltarConstellation());
        BlocksAS.ALTAR_RADIANCE = RegistryBlocks.registerBlock(new BlockAltarRadiance());
        BlocksAS.ATTUNEMENT_ALTAR = RegistryBlocks.registerBlock(new BlockAttunementAltar());
        BlocksAS.CELESTIAL_CRYSTAL_CLUSTER = RegistryBlocks.registerBlock(new BlockCelestialCrystalCluster());
        BlocksAS.GEM_CRYSTAL_CLUSTER = RegistryBlocks.registerBlock(new BlockGemCrystalCluster());
        BlocksAS.ROCK_COLLECTOR_CRYSTAL = RegistryBlocks.registerBlock(new BlockRockCollectorCrystal());
        BlocksAS.CELESTIAL_COLLECTOR_CRYSTAL = RegistryBlocks.registerBlock(new BlockCelestialCollectorCrystal());
        BlocksAS.LENS = RegistryBlocks.registerBlock(new BlockLens());
        BlocksAS.PRISM = RegistryBlocks.registerBlock(new BlockPrism());
        BlocksAS.RITUAL_LINK = RegistryBlocks.registerBlock(new BlockRitualLink());
        BlocksAS.RITUAL_PEDESTAL = RegistryBlocks.registerBlock(new BlockRitualPedestal());
        BlocksAS.INFUSER = RegistryBlocks.registerBlock(new BlockInfuser());
        BlocksAS.CHALICE = RegistryBlocks.registerBlock(new BlockChalice());
        BlocksAS.WELL = RegistryBlocks.registerBlock(new BlockWell());
        BlocksAS.ILLUMINATOR = RegistryBlocks.registerBlock(new BlockIlluminator());
        BlocksAS.TELESCOPE = RegistryBlocks.registerBlock(new BlockTelescope());
        BlocksAS.OBSERVATORY = RegistryBlocks.registerBlock(new BlockObservatory());
        BlocksAS.REFRACTION_TABLE = RegistryBlocks.registerBlock(new BlockRefractionTable());
        BlocksAS.TREE_BEACON = RegistryBlocks.registerBlock(new BlockTreeBeacon());
        BlocksAS.TREE_BEACON_COMPONENT = RegistryBlocks.registerBlock(new BlockTreeBeaconComponent());
        BlocksAS.GATEWAY = RegistryBlocks.registerBlock(new BlockCelestialGateway());
        BlocksAS.FOUNTAIN = RegistryBlocks.registerBlock(new BlockFountain());
        BlocksAS.FOUNTAIN_PRIME_LIQUID = RegistryBlocks.registerBlock(new BlockFountainPrimeLiquid());
        BlocksAS.FOUNTAIN_PRIME_VORTEX = RegistryBlocks.registerBlock(new BlockFountainPrimeVortex());
        BlocksAS.FOUNTAIN_PRIME_ORE = RegistryBlocks.registerBlock(new BlockFountainPrimeOre());
        BlocksAS.FLARE_LIGHT = RegistryBlocks.registerBlock(new BlockFlareLight());
        BlocksAS.TRANSLUCENT_BLOCK = RegistryBlocks.registerBlock(new BlockTranslucentBlock());
        BlocksAS.VANISHING = RegistryBlocks.registerBlock(new BlockVanishing());
        BlocksAS.STRUCTURAL = RegistryBlocks.registerBlock(new BlockStructural());
    }

    public static void registerFluidBlocks() {
        RegistryFluids.FLUID_BLOCKS.forEach(RegistryBlocks::registerBlock);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerColors(ColorHandlerEvent.Block blockColorEvent) {
        COLOR_BLOCKS.forEach(block -> blockColorEvent.getBlockColors().func_186722_a(block::getColor, new Block[]{(Block)block}));
    }

    private static BlockSlabTemplate makeSlab(BlockState base, String name) {
        BlockSlabTemplate slabs = new BlockSlabTemplate(base, AbstractBlock.Properties.func_200950_a((AbstractBlock)base.func_177230_c()));
        ResourceLocation slabsName = base.func_177230_c().getRegistryName();
        slabsName = new ResourceLocation(slabsName.func_110624_b(), name);
        return RegistryBlocks.registerBlock(slabs, slabsName);
    }

    private static BlockStairsTemplate makeStairs(BlockState base, String name) {
        BlockStairsTemplate stairs = new BlockStairsTemplate(base, AbstractBlock.Properties.func_200950_a((AbstractBlock)base.func_177230_c()));
        ResourceLocation stairsName = base.func_177230_c().getRegistryName();
        stairsName = new ResourceLocation(stairsName.func_110624_b(), name);
        return RegistryBlocks.registerBlock(stairs, stairsName);
    }

    private static <T extends Block> T registerBlock(T block) {
        return RegistryBlocks.registerBlock(block, NameUtil.fromClass(block, "Block"));
    }

    private static <T extends Block> T registerBlock(T block, ResourceLocation name) {
        block.setRegistryName(name);
        AstralSorcery.getProxy().getRegistryPrimer().register(block);
        if (block instanceof CustomItemBlock) {
            ITEM_BLOCKS.add((CustomItemBlock)block);
        }
        if (block instanceof BlockDynamicColor) {
            COLOR_BLOCKS.add((BlockDynamicColor)block);
        }
        return block;
    }
}

