/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.socket;

import hellfirepvp.astralsorcery.common.data.research.PerkAllocationType;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.lib.PerkNamesAS;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.node.MajorPerk;
import hellfirepvp.astralsorcery.common.perk.node.socket.GemSocketItem;
import hellfirepvp.astralsorcery.common.perk.node.socket.GemSocketPerk;
import hellfirepvp.astralsorcery.common.perk.tree.PerkTreeGem;
import hellfirepvp.astralsorcery.common.perk.tree.PerkTreePoint;
import java.util.Collection;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class GemSocketMajorPerk
extends MajorPerk
implements GemSocketPerk {
    public GemSocketMajorPerk(ResourceLocation name, float x, float y) {
        super(name, x, y);
        this.setName(PerkNamesAS.name("gem_socket"));
        this.disableTooltipCaching();
    }

    protected PerkTreePoint<? extends GemSocketMajorPerk> initPerkTreePoint() {
        return new PerkTreeGem<GemSocketMajorPerk>(this, this.getOffset());
    }

    @Override
    public Collection<PerkAttributeModifier> getModifiers(PlayerEntity player, LogicalSide side, boolean ignoreRequirements) {
        Collection<PerkAttributeModifier> mods = super.getModifiers(player, side, ignoreRequirements);
        ItemStack contained = this.getContainedItem(player, side);
        if (!contained.func_190926_b() && contained.func_77973_b() instanceof GemSocketItem) {
            mods.addAll(((GemSocketItem)contained.func_77973_b()).getModifiers(contained, this, player, side));
        }
        return mods;
    }

    @Override
    public void onRemovePerkServer(PlayerEntity player, PerkAllocationType allocationType, PlayerProgress progress, CompoundNBT dataStorage) {
        super.onRemovePerkServer(player, allocationType, progress, dataStorage);
        if (progress.getPerkData().getAllocationTypes(this).size() <= 1) {
            this.dropItemToPlayer(player, dataStorage);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean addLocalizedTooltip(Collection<IFormattableTextComponent> tooltip) {
        if (super.addLocalizedTooltip(tooltip)) {
            tooltip.add((IFormattableTextComponent)new StringTextComponent(""));
        }
        if (this.canSeeClient()) {
            this.addTooltipInfo(tooltip);
        }
        return true;
    }
}

