/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.client;

import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalPerkTree;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.useables.ItemPerkSeal;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktRequestPerkSealAction
extends ASPacket<PktRequestPerkSealAction> {
    private ResourceLocation perkKey;
    private boolean doSealing;

    public PktRequestPerkSealAction() {
    }

    public PktRequestPerkSealAction(AbstractPerk perk, boolean seal) {
        this.perkKey = perk.getRegistryName();
        this.doSealing = seal;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktRequestPerkSealAction> encoder() {
        return (packet, buffer) -> {
            ByteBufUtils.writeResourceLocation(buffer, packet.perkKey);
            buffer.writeBoolean(packet.doSealing);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktRequestPerkSealAction> decoder() {
        return buffer -> {
            PktRequestPerkSealAction pkt = new PktRequestPerkSealAction();
            pkt.perkKey = ByteBufUtils.readResourceLocation(buffer);
            pkt.doSealing = buffer.readBoolean();
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktRequestPerkSealAction> handler() {
        return new ASPacket.Handler<PktRequestPerkSealAction>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktRequestPerkSealAction packet, NetworkEvent.Context context) {
                Screen current = Minecraft.func_71410_x().field_71462_r;
                if (current instanceof ScreenJournalPerkTree) {
                    PerkTree.PERK_TREE.getPerk(LogicalSide.CLIENT, packet.perkKey).ifPresent(perk -> {
                        if (!packet.doSealing) {
                            Minecraft.func_71410_x().func_212871_a_(() -> ((ScreenJournalPerkTree)current).playSealBreakAnimation((AbstractPerk)perk));
                        } else {
                            Minecraft.func_71410_x().func_212871_a_(() -> ((ScreenJournalPerkTree)current).playSealApplyAnimation((AbstractPerk)perk));
                        }
                    });
                }
            }

            @Override
            public void handle(PktRequestPerkSealAction packet, NetworkEvent.Context context, LogicalSide side) {
                context.enqueueWork(() -> {
                    if (packet.perkKey == null) {
                        return;
                    }
                    PerkTree.PERK_TREE.getPerk(side, packet.perkKey).ifPresent(perk -> {
                        ServerPlayerEntity player = context.getSender();
                        if (packet.doSealing) {
                            if (ItemPerkSeal.useSeal((PlayerEntity)player, true) && ResearchManager.applyPerkSeal((PlayerEntity)player, perk)) {
                                if (!ItemPerkSeal.useSeal((PlayerEntity)player, false)) {
                                    ResearchManager.breakPerkSeal((PlayerEntity)player, perk);
                                } else {
                                    packet.replyWith(new PktRequestPerkSealAction((AbstractPerk)perk, true), context);
                                }
                            }
                        } else if (ResearchManager.breakPerkSeal((PlayerEntity)player, perk)) {
                            packet.replyWith(new PktRequestPerkSealAction((AbstractPerk)perk, false), context);
                        }
                    });
                });
            }
        };
    }
}

