/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event.helper;

import hellfirepvp.astralsorcery.common.enchantment.EnchantmentPlayerTick;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class EventHelperEnchantmentTick
implements ITickHandler {
    public static final EventHelperEnchantmentTick INSTANCE = new EventHelperEnchantmentTick();
    private Collection<EnchantmentPlayerTick> tickableEnchantments = null;

    private EventHelperEnchantmentTick() {
    }

    public void tick(TickEvent.Type type, Object ... context) {
        PlayerEntity player = (PlayerEntity)context[0];
        LogicalSide side = (LogicalSide)context[1];
        if (this.tickableEnchantments == null) {
            this.tickableEnchantments = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(enchantment -> enchantment instanceof EnchantmentPlayerTick).map(enchantment -> (EnchantmentPlayerTick)((Object)enchantment)).collect(Collectors.toList());
        }
        for (EnchantmentPlayerTick ench : this.tickableEnchantments) {
            int totalLevel = EnchantmentHelper.func_185284_a((Enchantment)ench, (LivingEntity)player);
            if (totalLevel <= 0) continue;
            ench.tick(player, side, totalLevel);
        }
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "TickEnchantment Helper";
    }
}

