/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event;

import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeTypeHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class AttributeEvent {
    public static double postProcessModded(PlayerEntity player, PerkAttributeType type, double value) {
        PostProcessModded ev = new PostProcessModded(value, type, player);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getValue();
    }

    public static float postProcessModded(PlayerEntity player, PerkAttributeType type, float value) {
        return (float)AttributeEvent.postProcessModded(player, type, (double)value);
    }

    public static double postProcessModded(PlayerEntity player, ResourceLocation key, double value) {
        PerkAttributeType pType = (PerkAttributeType)RegistriesAS.REGISTRY_PERK_ATTRIBUTE_TYPES.getValue(key);
        if (pType == null) {
            return value;
        }
        return AttributeEvent.postProcessModded(player, pType, value);
    }

    public static float postProcessModded(PlayerEntity player, ResourceLocation key, float value) {
        return (float)AttributeEvent.postProcessModded(player, key, (double)value);
    }

    public static double postProcessVanilla(double value, ModifiableAttributeInstance attribute) {
        PostProcessVanilla event = new PostProcessVanilla(attribute, value);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getAttribute().func_111109_a(event.getValue());
    }

    @Nullable
    private static LivingEntity getEntity(AttributeModifierManager map) {
        if (map instanceof EntityModifierManager) {
            return ((EntityModifierManager)map).getLivingEntity();
        }
        return null;
    }

    public static void setEntity(AttributeModifierManager map, LivingEntity entity) {
        if (map instanceof EntityModifierManager) {
            ((EntityModifierManager)map).setLivingEntity(entity);
        }
    }

    public static interface EntityModifierManager {
        @Nullable
        public LivingEntity getLivingEntity();

        public void setLivingEntity(LivingEntity var1);
    }

    public static class PostProcessModded
    extends Event {
        private final PlayerEntity player;
        private final PerkAttributeType type;
        private final double originalValue;
        private double value;

        public PostProcessModded(double value, PerkAttributeType type, PlayerEntity player) {
            this.player = player;
            this.type = type;
            this.originalValue = value;
            this.value = value;
        }

        public double getOriginalValue() {
            return this.originalValue;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public PerkAttributeType getType() {
            return this.type;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }
    }

    public static class PostProcessVanilla
    extends Event {
        private final ModifiableAttributeInstance instance;
        private final double originalValue;
        private double value;

        public PostProcessVanilla(ModifiableAttributeInstance instance, double value) {
            this.instance = instance;
            this.originalValue = value;
            this.value = value;
        }

        public double getOriginalValue() {
            return this.originalValue;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public ModifiableAttributeInstance getInstance() {
            return this.instance;
        }

        public Attribute getAttribute() {
            return this.instance.func_111123_a();
        }

        @Nullable
        public PerkAttributeType resolveAttributeType() {
            return PerkAttributeTypeHelper.findVanillaType(this.getAttribute());
        }
    }
}

