/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.server;

import hellfirepvp.astralsorcery.common.data.sync.base.AbstractData;
import hellfirepvp.astralsorcery.common.data.sync.base.AbstractDataProvider;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import hellfirepvp.astralsorcery.common.data.sync.client.ClientLightBlockEndpoints;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DataLightBlockEndpoints
extends AbstractData {
    private final Map<RegistryKey<World>, Set<BlockPos>> serverPositions = new HashMap<RegistryKey<World>, Set<BlockPos>>();
    private final Map<RegistryKey<World>, Map<BlockPos, Boolean>> serverChangeBuffer = new HashMap<RegistryKey<World>, Map<BlockPos, Boolean>>();
    private final Set<RegistryKey<World>> dimensionClearBuffer = new HashSet<RegistryKey<World>>();

    private DataLightBlockEndpoints(ResourceLocation key) {
        super(key);
    }

    public void updateNewEndpoint(RegistryKey<World> dim, BlockPos pos) {
        Map posMap = this.serverChangeBuffer.computeIfAbsent(dim, k -> new HashMap());
        posMap.put(pos, true);
        Set posBuffer = this.serverPositions.computeIfAbsent(dim, k -> new HashSet());
        posBuffer.add(pos);
        this.markDirty();
    }

    public void updateNewEndpoints(RegistryKey<World> dim, Collection<BlockPos> newPositions) {
        Map posMap = this.serverChangeBuffer.computeIfAbsent(dim, k -> new HashMap());
        for (BlockPos pos : newPositions) {
            posMap.put(pos, true);
        }
        Set posBuffer = this.serverPositions.computeIfAbsent(dim, k -> new HashSet());
        posBuffer.addAll(newPositions);
        this.markDirty();
    }

    public void removeEndpoints(RegistryKey<World> dim, Collection<BlockPos> positions) {
        Map posMap = this.serverChangeBuffer.computeIfAbsent(dim, k -> new HashMap());
        for (BlockPos pos : positions) {
            posMap.put(pos, false);
        }
        Set posBuffer = this.serverPositions.computeIfAbsent(dim, k -> new HashSet());
        if (posBuffer.removeAll(positions)) {
            this.markDirty();
        }
    }

    public boolean doesPositionReceiveStarlightServer(World world, BlockPos pos) {
        return this.serverPositions.getOrDefault(world.func_234923_W_(), Collections.emptySet()).contains(pos);
    }

    @Override
    public void clear(RegistryKey<World> dim) {
        if (this.serverPositions.remove(dim) != null) {
            this.serverChangeBuffer.remove(dim);
            this.dimensionClearBuffer.add(dim);
            this.markDirty();
        }
    }

    @Override
    public void clearServer() {
        this.dimensionClearBuffer.clear();
        this.serverChangeBuffer.clear();
        this.serverPositions.clear();
    }

    @Override
    public void writeAllDataToPacket(CompoundNBT compound) {
        for (RegistryKey<World> dim : this.serverPositions.keySet()) {
            Set<BlockPos> dat = this.serverPositions.get(dim);
            ListNBT dataList = new ListNBT();
            for (BlockPos pos : dat) {
                CompoundNBT cmp = new CompoundNBT();
                cmp.func_74772_a("pos", pos.func_218275_a());
                dataList.add((Object)cmp);
            }
            compound.func_218657_a(dim.func_240901_a_().toString(), (INBT)dataList);
        }
    }

    @Override
    public void writeDiffDataToPacket(CompoundNBT compound) {
        ListNBT clearList = new ListNBT();
        for (RegistryKey<World> dim : this.dimensionClearBuffer) {
            clearList.add((Object)StringNBT.func_229705_a_((String)dim.func_240901_a_().toString()));
        }
        compound.func_218657_a("clear", (INBT)clearList);
        for (RegistryKey<World> dim : this.serverChangeBuffer.keySet()) {
            if (this.dimensionClearBuffer.contains(dim)) continue;
            Map<BlockPos, Boolean> data = this.serverChangeBuffer.get(dim);
            ListNBT dataList = new ListNBT();
            for (BlockPos pos : data.keySet()) {
                CompoundNBT cmp = new CompoundNBT();
                cmp.func_74772_a("pos", pos.func_218275_a());
                cmp.func_74757_a("add", data.get(pos).booleanValue());
                dataList.add((Object)cmp);
            }
            compound.func_218657_a(dim.func_240901_a_().toString(), (INBT)dataList);
        }
        this.dimensionClearBuffer.clear();
        this.serverChangeBuffer.clear();
    }

    public static class Provider
    extends AbstractDataProvider<DataLightBlockEndpoints, ClientLightBlockEndpoints> {
        public Provider(ResourceLocation key) {
            super(key);
        }

        @Override
        public DataLightBlockEndpoints provideServerData() {
            return new DataLightBlockEndpoints(this.getKey());
        }

        @Override
        public ClientLightBlockEndpoints provideClientData() {
            return new ClientLightBlockEndpoints();
        }

        @Override
        public ClientDataReader<ClientLightBlockEndpoints> createReader() {
            return new ClientLightBlockEndpoints.Reader();
        }
    }
}

