/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry.sets;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataSet;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class TileAccelerationBlacklistEntry
implements ConfigDataSet,
Predicate<TileEntity> {
    private final String filterString;
    private Class<?> filteredSuperClass;

    public TileAccelerationBlacklistEntry(String filterString) {
        this.filterString = filterString;
        try {
            this.filteredSuperClass = Class.forName(filterString);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            this.filteredSuperClass = null;
        }
    }

    @Override
    public boolean test(TileEntity tile) {
        String testStr = this.filterString.toLowerCase(Locale.ROOT);
        if (testStr.isEmpty()) {
            return false;
        }
        if (this.filteredSuperClass != null) {
            return this.filteredSuperClass.isAssignableFrom(tile.getClass());
        }
        ResourceLocation key = tile.func_200662_C().getRegistryName();
        if (key != null && key.toString().toLowerCase(Locale.ROOT).startsWith(testStr)) {
            return true;
        }
        String className = tile.getClass().getName().toLowerCase(Locale.ROOT);
        return className.startsWith(testStr);
    }

    @Override
    @Nonnull
    public String serialize() {
        return this.filterString;
    }
}

