/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomMatcherRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeSerializer;
import hellfirepvp.astralsorcery.common.crafting.recipe.GatedRecipe;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.lib.RecipeSerializersAS;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.tile.TileInfuser;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.JsonHelper;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class LiquidInfusion
extends CustomMatcherRecipe
implements GatedRecipe.Progression {
    private final int craftingTickTime;
    private final Fluid liquidInput;
    private final Ingredient itemInput;
    private final ItemStack output;
    private final float consumptionChance;
    private final boolean consumeMultipleFluids;
    private final boolean acceptChaliceInput;
    private final boolean copyNBTToOutputs;

    public LiquidInfusion(ResourceLocation recipeId, int craftingTickTime, Fluid liquidInput, Ingredient itemInput, ItemStack itemOutput, float consumptionChance, boolean consumeMultipleFluids, boolean acceptChaliceInput, boolean copyNBTToOutputs) {
        super(recipeId);
        this.craftingTickTime = craftingTickTime;
        this.liquidInput = liquidInput;
        this.itemInput = itemInput;
        this.output = itemOutput;
        this.consumptionChance = consumptionChance;
        this.consumeMultipleFluids = consumeMultipleFluids;
        this.acceptChaliceInput = acceptChaliceInput;
        this.copyNBTToOutputs = copyNBTToOutputs;
    }

    public boolean matches(TileInfuser infuser, PlayerEntity crafter, LogicalSide side) {
        if (crafter == null) {
            return false;
        }
        boolean hasProgress = side.isClient() ? this.hasProgressionClient() : this.hasProgressionServer(crafter);
        if (!hasProgress) {
            return false;
        }
        boolean hasFluidInputs = MapStream.of(infuser.getLiquids()).mapKey(pos -> pos.func_177971_a((Vector3i)infuser.func_174877_v())).allMatch((Predicate<Tuple<BlockPos, Fluid>>)((Predicate<Tuple>)tpl -> this.liquidInput.equals(tpl.func_76340_b())));
        if (!hasFluidInputs) {
            return false;
        }
        return this.itemInput.test(infuser.getItemInput());
    }

    @Override
    @Nonnull
    public ResearchProgression getRequiredProgression() {
        return ResearchProgression.CONSTELLATION;
    }

    public int getCraftingTickTime() {
        return this.craftingTickTime;
    }

    @Nonnull
    public Fluid getLiquidInput() {
        return this.liquidInput;
    }

    @Nonnull
    public Ingredient getItemInput() {
        return this.itemInput;
    }

    public void onRecipeCompletion(TileInfuser infuser) {
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getOutputForRender(Iterable<ItemStack> inventoryContents) {
        return ItemUtils.copyStackWithSize(this.output, this.output.func_190916_E());
    }

    @Nonnull
    public ItemStack getOutput(ItemStack itemInput) {
        return ItemUtils.copyStackWithSize(this.output, this.output.func_190916_E());
    }

    public float getConsumptionChance() {
        return MathHelper.func_76131_a((float)this.consumptionChance, (float)0.0f, (float)1.0f);
    }

    public boolean doesConsumeMultipleFluids() {
        return this.consumeMultipleFluids;
    }

    public boolean acceptsChaliceInput() {
        return this.acceptChaliceInput;
    }

    public boolean doesCopyNBTToOutputs() {
        return this.copyNBTToOutputs;
    }

    public static LiquidInfusion read(ResourceLocation recipeId, PacketBuffer buffer) {
        Fluid fluidIn = (Fluid)ByteBufUtils.readRegistryEntry(buffer);
        Ingredient itemIn = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack output = ByteBufUtils.readItemStack(buffer);
        float consumptionChance = buffer.readFloat();
        int duration = buffer.readInt();
        boolean consumeMultiple = buffer.readBoolean();
        boolean acceptChalice = buffer.readBoolean();
        boolean copyNBTToOutputs = buffer.readBoolean();
        return new LiquidInfusion(recipeId, duration, fluidIn, itemIn, output, consumptionChance, consumeMultiple, acceptChalice, copyNBTToOutputs);
    }

    public final void write(PacketBuffer buffer) {
        ByteBufUtils.writeRegistryEntry(buffer, this.getLiquidInput());
        this.getItemInput().func_199564_a(buffer);
        ByteBufUtils.writeItemStack(buffer, this.output);
        buffer.writeFloat(this.getConsumptionChance());
        buffer.writeInt(this.getCraftingTickTime());
        buffer.writeBoolean(this.doesConsumeMultipleFluids());
        buffer.writeBoolean(this.acceptsChaliceInput());
        buffer.writeBoolean(this.doesCopyNBTToOutputs());
    }

    public void write(JsonObject object) {
        object.addProperty("fluidInput", this.getLiquidInput().getRegistryName().toString());
        object.add("input", this.getItemInput().func_200304_c());
        object.add("output", (JsonElement)JsonHelper.serializeItemStack(this.output));
        object.addProperty("consumptionChance", (Number)Float.valueOf(this.getConsumptionChance()));
        object.addProperty("duration", (Number)this.getCraftingTickTime());
        object.addProperty("consumeMultipleFluids", Boolean.valueOf(this.doesConsumeMultipleFluids()));
        object.addProperty("acceptChaliceInput", Boolean.valueOf(this.acceptsChaliceInput()));
        object.addProperty("copyNBTToOutputs", Boolean.valueOf(this.doesCopyNBTToOutputs()));
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypesAS.TYPE_INFUSION.getType();
    }

    @Override
    public CustomRecipeSerializer<?> getSerializer() {
        return RecipeSerializersAS.LIQUID_INFUSION_SERIALIZER;
    }
}

