/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.attunement.active;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXMotionController;
import hellfirepvp.astralsorcery.client.effect.function.impl.RenderOffsetNoisePlane;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightbeam;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.util.camera.ClientCameraManager;
import hellfirepvp.astralsorcery.client.util.camera.ICameraPersistencyFunction;
import hellfirepvp.astralsorcery.client.util.camera.ICameraStopListener;
import hellfirepvp.astralsorcery.client.util.camera.ICameraTickListener;
import hellfirepvp.astralsorcery.client.util.camera.ICameraTransformer;
import hellfirepvp.astralsorcery.client.util.camera.path.CameraPathBuilder;
import hellfirepvp.astralsorcery.client.util.sound.FadeSound;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.crafting.nojson.attunement.AttunePlayerRecipe;
import hellfirepvp.astralsorcery.common.crafting.nojson.attunement.AttunementRecipe;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.helper.EventHelperInvulnerability;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.client.PktAttunePlayerConstellation;
import hellfirepvp.astralsorcery.common.tile.TileAttunementAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class ActivePlayerAttunementRecipe
extends AttunementRecipe.Active<AttunePlayerRecipe> {
    private static final int DURATION_PLAYER_ATTUNEMENT = 800;
    private IMajorConstellation constellation;
    private UUID playerUUID;
    public Object cameraHack;
    private boolean startedPlayerSound = false;
    private List<Object> playerNoisePlanes = new ArrayList<Object>();

    public ActivePlayerAttunementRecipe(AttunePlayerRecipe recipe, IMajorConstellation constellation, UUID playerUUID) {
        super(recipe);
        this.constellation = constellation;
        this.playerUUID = playerUUID;
    }

    public ActivePlayerAttunementRecipe(AttunePlayerRecipe recipe, CompoundNBT nbt) {
        super(recipe);
        this.readFromNBT(nbt);
    }

    @Override
    public boolean matches(TileAttunementAltar altar) {
        if (!super.matches(altar)) {
            return false;
        }
        PlayerEntity player = altar.func_145831_w().func_217371_b(this.playerUUID);
        return player != null && player.func_70089_S();
    }

    @Override
    public void startCrafting(TileAttunementAltar altar) {
        PlayerEntity player = altar.func_145831_w().func_217371_b(this.playerUUID);
        if (player != null && player.func_70089_S()) {
            Vector3 offset = new Vector3(altar).add(0.5f, 1.2f, 0.5f);
            player.func_70080_a(offset.getX(), offset.getY(), offset.getZ(), 0.0f, 0.0f);
            player.func_70080_a(offset.getX(), offset.getY(), offset.getZ(), 0.0f, 0.0f);
        }
    }

    @Override
    public void stopCrafting(TileAttunementAltar altar) {
    }

    @Override
    public void finishRecipe(TileAttunementAltar altar) {
        PlayerEntity player = altar.func_145831_w().func_217371_b(this.playerUUID);
        if (player != null) {
            ResearchManager.setAttunedConstellation(player, this.constellation);
        }
    }

    @Override
    public void doTick(LogicalSide side, TileAttunementAltar altar) {
        if (side.isServer()) {
            PlayerEntity player = altar.func_145831_w().func_217371_b(this.playerUUID);
            if (player != null) {
                EventHelperInvulnerability.makeInvulnerable(player);
            }
        } else {
            this.setupPlanes();
            this.doClientSetup(altar);
            this.doEffectTick(altar);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupPlanes() {
        if (this.playerNoisePlanes.isEmpty()) {
            this.playerNoisePlanes.add(new RenderOffsetNoisePlane(1.0f));
            this.playerNoisePlanes.add(new RenderOffsetNoisePlane(1.4f));
            this.playerNoisePlanes.add(new RenderOffsetNoisePlane(1.8f));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doEffectTick(TileAttunementAltar altar) {
        int i;
        IConstellation cst = altar.getActiveConstellation();
        if (cst == null) {
            return;
        }
        Vector3 playerTarget = new Vector3(altar).add(0.5, 2.5, 0.5);
        VFXColorFunction beamColor = VFXColorFunction.constant(ColorsAS.DEFAULT_GENERIC_PARTICLE);
        int tick = this.getTick();
        if (tick % 40 == 0) {
            for (BlockPos pos : altar.getConstellationPositions(cst)) {
                Vector3 from = new Vector3((Vector3i)pos).add(0.5, 0.0, 0.5);
                MiscUtils.applyRandomOffset(from, this.rand, 0.1f);
                ((EntityComplexFX)((EntityVisualFX)((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(from)).setup(from.clone().addY(6.0), 1.2, 1.2).setAlphaMultiplier(0.8f)).color(beamColor)).setMaxAge(60);
            }
        }
        double scale = 7.0;
        double edgeScale = scale * 2.0 + 1.0;
        for (i = 0; i < 7; ++i) {
            Vector3 offset = new Vector3(altar).add(-scale, 0.1, -scale);
            if (this.rand.nextBoolean()) {
                offset.add(edgeScale * (double)(this.rand.nextBoolean() ? 1 : 0), 0.0, (double)this.rand.nextFloat() * edgeScale);
            } else {
                offset.add((double)this.rand.nextFloat() * edgeScale, 0.0, edgeScale * (double)(this.rand.nextBoolean() ? 1 : 0));
            }
            FXFacingParticle particle = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(offset)).alpha(VFXAlphaFunction.FADE_OUT)).setGravityStrength(-2.0E-4f + this.rand.nextFloat() * -1.0E-4f)).setScaleMultiplier(0.3f + this.rand.nextFloat() * 0.15f)).color(VFXColorFunction.WHITE)).setMaxAge(40 + this.rand.nextInt(10));
            if (!this.rand.nextBoolean()) continue;
            particle.color(VFXColorFunction.constant(this.constellation.getConstellationColor()));
        }
        for (i = 0; i < 5; ++i) {
            Vector3 offset;
            Set<BlockPos> offsets = altar.getConstellationPositions(cst);
            BlockPos pos = MiscUtils.getRandomEntry(offsets, this.rand);
            if (tick <= 380) {
                offset = new Vector3((Vector3i)pos).add(0.5, 0.0, 0.5).add(Vector3.random().setY(0).multiply(0.6));
                ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(offset)).color(VFXColorFunction.WHITE)).setGravityStrength(-6.0E-4f + this.rand.nextFloat() * -0.003f)).setMotion(Vector3.random().addY(4.0).normalize().multiply(0.015 + (double)this.rand.nextFloat() * 0.01))).setAlphaMultiplier(0.6f)).setScaleMultiplier(0.3f + this.rand.nextFloat() * 0.15f)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(60 + this.rand.nextInt(20));
                continue;
            }
            offset = new Vector3((Vector3i)pos).add(0.5, 0.0, 0.5).add(Vector3.random().setY(0).multiply(0.5));
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(offset)).setAlphaMultiplier(0.6f)).alpha(VFXAlphaFunction.proximity(playerTarget::clone, 3.0f))).motion(VFXMotionController.target(playerTarget::clone, 0.08f))).setScaleMultiplier(0.2f + this.rand.nextFloat() * 0.1f)).color(VFXColorFunction.WHITE)).setMotion(new Vector3(0.0, 0.2 + (double)(this.rand.nextFloat() * 0.15f), 0.0))).setMaxAge(60 + this.rand.nextInt(20));
            offset = new Vector3(altar).add(0.5, 0.0, 0.5).add(Vector3.random().setY(0).multiply(0.6));
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(offset)).color(VFXColorFunction.WHITE)).setGravityStrength(-6.0E-4f + this.rand.nextFloat() * -0.004f)).setMotion(Vector3.random().addY(4.0).normalize().multiply(0.02 + (double)this.rand.nextFloat() * 0.01))).setAlphaMultiplier(0.75f)).setScaleMultiplier(0.3f + this.rand.nextFloat() * 0.1f)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(40 + this.rand.nextInt(10));
        }
        if (tick >= 220) {
            Vector3 offset = new Vector3(altar).add(0.5, 0.0, 0.5).add(Vector3.random().setY(0));
            FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(offset)).setAlphaMultiplier(1.0f)).alpha(VFXAlphaFunction.proximity(playerTarget::clone, 3.0f))).motion(VFXMotionController.target(playerTarget::clone, 0.1f))).setScaleMultiplier(0.2f + this.rand.nextFloat() * 0.1f)).color(VFXColorFunction.WHITE)).setMotion(Vector3.positiveYRandom().setY(1).normalize().multiply(0.5f + this.rand.nextFloat() * 0.1f))).setMaxAge(60 + this.rand.nextInt(20));
            if (this.rand.nextBoolean()) {
                p.color(VFXColorFunction.constant(this.constellation.getConstellationColor()));
            }
            for (int i2 = 0; i2 < 3; ++i2) {
                Vector3 at = new Vector3(altar).add(0.5, 0.0, 0.5);
                at.addX(this.rand.nextFloat() * 7.0f * (float)(this.rand.nextBoolean() ? 1 : -1));
                at.addZ(this.rand.nextFloat() * 7.0f * (float)(this.rand.nextBoolean() ? 1 : -1));
                p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).setAlphaMultiplier(0.75f)).alpha(VFXAlphaFunction.FADE_OUT)).setGravityStrength(-0.001f + this.rand.nextFloat() * -5.0E-4f)).color(VFXColorFunction.WHITE)).setScaleMultiplier(0.3f + this.rand.nextFloat() * 0.1f)).setMaxAge(20 + this.rand.nextInt(10));
                if (this.rand.nextBoolean()) {
                    p.color(VFXColorFunction.constant(this.constellation.getConstellationColor()));
                }
                if (tick < 500) continue;
                p.setScaleMultiplier(0.3f + this.rand.nextFloat() * 0.15f);
            }
        }
        if (tick >= 400) {
            int amt = tick >= 500 ? 4 : 1;
            for (int i3 = 0; i3 < amt; ++i3) {
                RenderOffsetNoisePlane plane = (RenderOffsetNoisePlane)MiscUtils.getRandomEntry(this.playerNoisePlanes, this.rand);
                FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)plane.createParticle(playerTarget.clone()).setMotion(Vector3.random().setY(0).multiply(this.rand.nextFloat() * 0.015f))).setAlphaMultiplier(0.6f)).setScaleMultiplier(0.2f + this.rand.nextFloat() * 0.05f)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(60 + this.rand.nextInt(20));
                if (!this.rand.nextBoolean()) continue;
                p.color(VFXColorFunction.constant(this.constellation.getConstellationColor()));
            }
        }
        if (tick >= 600 && tick % 10 == 0) {
            Vector3 from = new Vector3(altar).add(0.5, 0.0, 0.5);
            MiscUtils.applyRandomOffset(from, this.rand, 0.25f);
            ((EntityComplexFX)((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(from)).setup(from.clone().addY(8.0), 2.4, 2.0).setAlphaMultiplier(0.8f)).setMaxAge(40 + this.rand.nextInt(20));
        }
        if (tick >= 796) {
            for (int i4 = 0; i4 < 60; ++i4) {
                Vector3 at = new Vector3(altar).add(0.5, 0.0, 0.5).addY(this.rand.nextFloat() * 15.0f);
                FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).color(VFXColorFunction.WHITE)).setMotion(Vector3.random().setY(0).normalize().multiply(0.03 + (double)this.rand.nextFloat() * 0.01))).setAlphaMultiplier(0.7f)).setScaleMultiplier(0.3f + this.rand.nextFloat() * 0.15f)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(140 + this.rand.nextInt(60));
                if (!this.rand.nextBoolean()) continue;
                p.color(VFXColorFunction.constant(this.constellation.getConstellationColor()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doClientSetup(TileAttunementAltar altar) {
        if (this.cameraHack == null && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(this.getPlayerUUID())) {
            Vector3 offset = new Vector3(altar).add(0.5, 6.0, 0.5);
            CameraPathBuilder builder = CameraPathBuilder.builder(offset.clone().add(4.0f, 0.0f, 4.0f), new Vector3(altar).add(0.5, 0.5, 0.5));
            builder.addCircularPoints(offset, CameraPathBuilder.DynamicRadiusGetter.dyanmicIncrease(5.0, 0.025), 200, 2);
            builder.addCircularPoints(offset, CameraPathBuilder.DynamicRadiusGetter.dyanmicIncrease(10.0, -0.01), 200, 2);
            builder.setTickDelegate(this.createTickListener(new Vector3(altar).add(0.5f, 1.2f, 0.5f)));
            builder.setStopDelegate(this.createAttunementListener(altar));
            this.cameraHack = builder.finishAndStart();
        }
        if (!this.startedPlayerSound) {
            this.startedPlayerSound = true;
            ((FadeSound)((Object)SoundHelper.playSoundFadeInClient(SoundsAS.ATTUNEMENT_ATLAR_PLAYER_ATTUNE, new Vector3(altar).add(0.5, 1.0, 0.5), 0.7f, 1.0f, false, s -> !altar.canPlayConstellationActiveEffects() || altar.getActiveRecipe() != this).setFadeInTicks(10.0f))).setFadeOutTicks(80.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private ICameraTickListener createTickListener(Vector3 offset) {
        return (renderView, focusedEntity) -> {
            if (focusedEntity == null) {
                return;
            }
            float floatTick = (float)(ClientScheduler.getClientTick() % 40L) / 40.0f;
            float sin = MathHelper.func_76126_a((float)((float)((double)(floatTick * 2.0f) * Math.PI))) / 2.0f + 0.5f;
            focusedEntity.func_174805_g(false);
            focusedEntity.func_70080_a(offset.getX(), offset.getY() + (double)sin * 0.2, offset.getZ(), 0.0f, 0.0f);
            focusedEntity.func_70080_a(offset.getX(), offset.getY() + (double)sin * 0.2, offset.getZ(), 0.0f, 0.0f);
            focusedEntity.field_70759_as = 0.0f;
            focusedEntity.field_70758_at = 0.0f;
            focusedEntity.field_70761_aq = 0.0f;
            focusedEntity.field_70760_ar = 0.0f;
            focusedEntity.func_70016_h(0.0, 0.0, 0.0);
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    private ICameraStopListener createAttunementListener(TileAttunementAltar altar) {
        BlockPos at = altar.func_174877_v();
        return () -> {
            ICameraTransformer transformer;
            ICameraPersistencyFunction persistency;
            if (this.cameraHack != null && (persistency = (transformer = (ICameraTransformer)this.cameraHack).getPersistencyFunction()).isExpired() && !persistency.wasForciblyStopped()) {
                PktAttunePlayerConstellation attuneRequest = new PktAttunePlayerConstellation(this.constellation, (RegistryKey<World>)altar.func_145831_w().func_234923_W_(), at);
                PacketChannel.CHANNEL.sendToServer(attuneRequest);
            }
        };
    }

    @Override
    public boolean isFinished(TileAttunementAltar altar) {
        return this.getTick() >= 800;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void stopEffects(TileAttunementAltar altar) {
        if (this.cameraHack != null) {
            ClientCameraManager.INSTANCE.removeTransformer((ICameraTransformer)this.cameraHack);
        }
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        super.writeToNBT(nbt);
        nbt.func_186854_a("playerUUID", this.playerUUID);
        nbt.func_74778_a("constellation", this.constellation.getRegistryName().toString());
    }

    @Override
    protected void readFromNBT(CompoundNBT nbt) {
        super.readFromNBT(nbt);
        this.playerUUID = nbt.func_186857_a("playerUUID");
        this.constellation = (IMajorConstellation)RegistriesAS.REGISTRY_CONSTELLATIONS.getValue(new ResourceLocation(nbt.func_74779_i("constellation")));
    }
}

