/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import hellfirepvp.astralsorcery.common.CommonScheduler;
import hellfirepvp.astralsorcery.common.GuiType;
import hellfirepvp.astralsorcery.common.auxiliary.BlockBreakHelper;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.auxiliary.gateway.CelestialGatewayHandler;
import hellfirepvp.astralsorcery.common.auxiliary.link.LinkHandler;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonDataManager;
import hellfirepvp.astralsorcery.common.base.patreon.manager.PatreonManager;
import hellfirepvp.astralsorcery.common.cmd.CommandAstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffectRegistry;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeTypeHandler;
import hellfirepvp.astralsorcery.common.data.config.CommonConfig;
import hellfirepvp.astralsorcery.common.data.config.ServerConfig;
import hellfirepvp.astralsorcery.common.data.config.base.BaseConfiguration;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigRegistries;
import hellfirepvp.astralsorcery.common.data.config.entry.CraftingConfig;
import hellfirepvp.astralsorcery.common.data.config.entry.EntityConfig;
import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import hellfirepvp.astralsorcery.common.data.config.entry.LightNetworkConfig;
import hellfirepvp.astralsorcery.common.data.config.entry.LogConfig;
import hellfirepvp.astralsorcery.common.data.config.entry.MachineryConfig;
import hellfirepvp.astralsorcery.common.data.config.entry.PerkConfig;
import hellfirepvp.astralsorcery.common.data.config.entry.ToolsConfig;
import hellfirepvp.astralsorcery.common.data.config.entry.WandsConfig;
import hellfirepvp.astralsorcery.common.data.config.entry.WorldGenConfig;
import hellfirepvp.astralsorcery.common.data.config.entry.common.CommonGeneralConfig;
import hellfirepvp.astralsorcery.common.data.config.registry.AmuletEnchantmentRegistry;
import hellfirepvp.astralsorcery.common.data.config.registry.EntityTransmutationRegistry;
import hellfirepvp.astralsorcery.common.data.config.registry.FluidRarityRegistry;
import hellfirepvp.astralsorcery.common.data.config.registry.OreBlockRarityRegistry;
import hellfirepvp.astralsorcery.common.data.config.registry.OreItemRarityRegistry;
import hellfirepvp.astralsorcery.common.data.config.registry.TechnicalEntityRegistry;
import hellfirepvp.astralsorcery.common.data.config.registry.TileAccelerationBlacklistRegistry;
import hellfirepvp.astralsorcery.common.data.config.registry.WeightedPerkAttributeRegistry;
import hellfirepvp.astralsorcery.common.data.research.ResearchIOThread;
import hellfirepvp.astralsorcery.common.data.sync.SyncDataHolder;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletRandomizeHelper;
import hellfirepvp.astralsorcery.common.enchantment.amulet.PlayerAmuletHandler;
import hellfirepvp.astralsorcery.common.event.PlayerAffectionFlags;
import hellfirepvp.astralsorcery.common.event.handler.EventHandlerAutoLink;
import hellfirepvp.astralsorcery.common.event.handler.EventHandlerBlockStorage;
import hellfirepvp.astralsorcery.common.event.handler.EventHandlerCache;
import hellfirepvp.astralsorcery.common.event.handler.EventHandlerInteract;
import hellfirepvp.astralsorcery.common.event.handler.EventHandlerMisc;
import hellfirepvp.astralsorcery.common.event.helper.EventHelperDamageCancelling;
import hellfirepvp.astralsorcery.common.event.helper.EventHelperEnchantmentTick;
import hellfirepvp.astralsorcery.common.event.helper.EventHelperEntityFreeze;
import hellfirepvp.astralsorcery.common.event.helper.EventHelperInvulnerability;
import hellfirepvp.astralsorcery.common.event.helper.EventHelperSpawnDeny;
import hellfirepvp.astralsorcery.common.event.helper.EventHelperTemporaryFlight;
import hellfirepvp.astralsorcery.common.integration.IntegrationCraftTweaker;
import hellfirepvp.astralsorcery.common.integration.IntegrationCurios;
import hellfirepvp.astralsorcery.common.item.armor.ArmorMaterialImbuedLeather;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktOpenGui;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeLimiter;
import hellfirepvp.astralsorcery.common.perk.PerkCooldownHelper;
import hellfirepvp.astralsorcery.common.perk.PerkLevelManager;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.perk.data.PerkTreeLoader;
import hellfirepvp.astralsorcery.common.perk.data.PerkTypeHandler;
import hellfirepvp.astralsorcery.common.perk.source.ModifierManager;
import hellfirepvp.astralsorcery.common.perk.tick.PerkTickHelper;
import hellfirepvp.astralsorcery.common.registry.RegistryAdvancements;
import hellfirepvp.astralsorcery.common.registry.RegistryArgumentTypes;
import hellfirepvp.astralsorcery.common.registry.RegistryCapabilities;
import hellfirepvp.astralsorcery.common.registry.RegistryConstellations;
import hellfirepvp.astralsorcery.common.registry.RegistryData;
import hellfirepvp.astralsorcery.common.registry.RegistryEntities;
import hellfirepvp.astralsorcery.common.registry.RegistryGameRules;
import hellfirepvp.astralsorcery.common.registry.RegistryIngredientTypes;
import hellfirepvp.astralsorcery.common.registry.RegistryMaterials;
import hellfirepvp.astralsorcery.common.registry.RegistryPerks;
import hellfirepvp.astralsorcery.common.registry.RegistryRegistries;
import hellfirepvp.astralsorcery.common.registry.RegistryStructureTypes;
import hellfirepvp.astralsorcery.common.registry.RegistryWorldGeneration;
import hellfirepvp.astralsorcery.common.registry.internal.InternalRegistryPrimer;
import hellfirepvp.astralsorcery.common.registry.internal.PrimerEventHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightNetworkRegistry;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightUpdateHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionChunkTracker;
import hellfirepvp.astralsorcery.common.tile.TileTreeBeacon;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.DamageSourceUtil;
import hellfirepvp.astralsorcery.common.util.ServerLifecycleListener;
import hellfirepvp.astralsorcery.common.util.collision.CollisionManager;
import hellfirepvp.astralsorcery.common.util.time.TimeStopController;
import hellfirepvp.observerlib.common.event.BlockChangeNotifier;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import hellfirepvp.observerlib.common.util.tick.TickManager;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

public class CommonProxy {
    public static final UUID FAKEPLAYER_UUID = UUID.fromString("b0c3097f-8391-4b4b-a89a-553ef730b13a");
    public static DamageSource DAMAGE_SOURCE_BLEED = DamageSourceUtil.newType("astralsorcery.bleed").func_76348_h();
    public static DamageSource DAMAGE_SOURCE_STELLAR = DamageSourceUtil.newType("astralsorcery.stellar").func_76348_h().func_82726_p();
    public static DamageSource DAMAGE_SOURCE_REFLECT = DamageSourceUtil.newType("thorns").func_76348_h().func_151518_m();
    public static final ItemGroup ITEM_GROUP_AS = new ItemGroup("astralsorcery"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemsAS.TOME);
        }
    };
    public static final ItemGroup ITEM_GROUP_AS_PAPERS = new ItemGroup("astralsorcery.papers"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemsAS.CONSTELLATION_PAPER);
        }
    };
    public static final ItemGroup ITEM_GROUP_AS_CRYSTALS = new ItemGroup("astralsorcery.crystals"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemsAS.ROCK_CRYSTAL);
        }
    };
    public static final Rarity RARITY_CELESTIAL = Rarity.create((String)"AS_CELESTIAL", (TextFormatting)TextFormatting.BLUE);
    public static final Rarity RARITY_ARTIFACT = Rarity.create((String)"AS_ARTIFACT", (TextFormatting)TextFormatting.GOLD);
    public static final Rarity RARITY_VESTIGE = Rarity.create((String)"AS_VESTIGE", (TextFormatting)TextFormatting.RED);
    public static final IArmorMaterial ARMOR_MATERIAL_IMBUED_LEATHER = new ArmorMaterialImbuedLeather();
    private InternalRegistryPrimer registryPrimer;
    private PrimerEventHandler registryEventHandler;
    private CommonScheduler commonScheduler;
    private TickManager tickManager;
    private final List<ServerLifecycleListener> serverLifecycleListeners = Lists.newArrayList();
    private CommonConfig commonConfig;
    private ServerConfig serverConfig;

    public void initialize() {
        this.registryPrimer = new InternalRegistryPrimer();
        this.registryEventHandler = new PrimerEventHandler(this.registryPrimer);
        this.commonScheduler = new CommonScheduler();
        this.commonConfig = new CommonConfig();
        this.serverConfig = new ServerConfig();
        RegistryData.init();
        RegistryMaterials.init();
        RegistryGameRules.init();
        RegistryStructureTypes.init();
        PacketChannel.registerPackets();
        RegistryIngredientTypes.init();
        RegistryAdvancements.init();
        AltarRecipeTypeHandler.init();
        PerkTypeHandler.init();
        ModifierManager.init();
        RegistryConstellations.init();
        RegistryArgumentTypes.init();
        this.initializeConfigurations();
        ConfigRegistries.getRegistries().buildDataRegistries(this.serverConfig);
        this.tickManager = new TickManager();
        this.attachTickListeners(arg_0 -> ((TickManager)this.tickManager).register(arg_0));
        this.serverLifecycleListeners.add(ResearchIOThread.getInstance());
        this.serverLifecycleListeners.add(ServerLifecycleListener.wrap(EventHandlerCache::onServerStart, EventHandlerCache::onServerStop));
        this.serverLifecycleListeners.add(ServerLifecycleListener.wrap(CelestialGatewayHandler.INSTANCE::onServerStart, CelestialGatewayHandler.INSTANCE::onServerStop));
        this.serverLifecycleListeners.add(ServerLifecycleListener.start(PerkTree.PERK_TREE::setupServerPerkTree));
        this.serverLifecycleListeners.add(ServerLifecycleListener.start(PerkLevelManager::loadPerkLevels));
        this.serverLifecycleListeners.add(ServerLifecycleListener.stop(BlockBreakHelper::clearServerCache));
        this.serverLifecycleListeners.add(ServerLifecycleListener.stop(TileTreeBeacon.TreeWatcher::clearServerCache));
        this.serverLifecycleListeners.add(ServerLifecycleListener.stop(PlayerAffectionFlags::clearServerCache));
        SyncDataHolder.initialize();
        this.commonConfig.buildConfiguration();
    }

    public void attachLifecycle(IEventBus modEventBus) {
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(this::onEnqueueIMC);
        modEventBus.addListener(BaseConfiguration::refreshConfiguration);
        modEventBus.addListener(RegistryRegistries::buildRegistries);
        modEventBus.addListener(RegistryEntities::initAttributes);
        this.registryEventHandler.attachEventHandlers(modEventBus);
    }

    public void attachEventHandlers(IEventBus eventBus) {
        eventBus.addListener(this::onRegisterCommands);
        eventBus.addListener(this::onServerStop);
        eventBus.addListener(this::onServerStopping);
        eventBus.addListener(this::onServerStarting);
        eventBus.addListener(this::onServerStarted);
        eventBus.addListener(this::onRegisterReloadListeners);
        EventHandlerInteract.attachListeners(eventBus);
        EventHandlerCache.attachListeners(eventBus);
        EventHandlerBlockStorage.attachListeners(eventBus);
        EventHandlerMisc.attachListeners(eventBus);
        EventHelperSpawnDeny.attachListeners(eventBus);
        EventHelperInvulnerability.attachListeners(eventBus);
        EventHelperEntityFreeze.attachListeners(eventBus);
        EventHelperDamageCancelling.attachListeners(eventBus);
        PerkAttributeLimiter.attachListeners(eventBus);
        eventBus.addListener(RegistryWorldGeneration::loadBiomeFeatures);
        eventBus.addListener(PlayerAmuletHandler::onEnchantmentAdd);
        eventBus.addListener(BlockDropCaptureAssist.INSTANCE::onDrop);
        eventBus.addListener(CelestialGatewayHandler.INSTANCE::onWorldInit);
        eventBus.addListener(EventPriority.LOW, TileTreeBeacon.TreeWatcher::onGrow);
        this.tickManager.attachListeners(eventBus);
        TransmissionChunkTracker.INSTANCE.attachListeners(eventBus);
        BlockChangeNotifier.addListener((BlockChangeNotifier.Listener)new EventHandlerAutoLink());
        Mods.CRAFTTWEAKER.executeIfPresent(() -> () -> IntegrationCraftTweaker.attachListeners(eventBus));
    }

    public void attachTickListeners(Consumer<ITickHandler> registrar) {
        registrar.accept(this.commonScheduler);
        registrar.accept(StarlightTransmissionHandler.getInstance());
        registrar.accept(StarlightUpdateHandler.getInstance());
        registrar.accept(SyncDataHolder.getTickInstance());
        registrar.accept(LinkHandler.getInstance());
        registrar.accept(SkyHandler.getInstance());
        registrar.accept(PlayerAmuletHandler.INSTANCE);
        registrar.accept(PerkTickHelper.INSTANCE);
        registrar.accept(PatreonManager.INSTANCE);
        registrar.accept(TimeStopController.INSTANCE);
        registrar.accept(AlignmentChargeHandler.INSTANCE);
        registrar.accept(ModifierManager.INSTANCE);
        registrar.accept(EventHelperEnchantmentTick.INSTANCE);
        EventHelperTemporaryFlight.attachTickListener(registrar);
        EventHelperSpawnDeny.attachTickListener(registrar);
        EventHelperInvulnerability.attachTickListener(registrar);
        EventHelperEntityFreeze.attachTickListener(registrar);
        PerkCooldownHelper.attachTickListeners(registrar);
        PlayerAffectionFlags.attachTickListeners(registrar);
    }

    protected void initializeConfigurations() {
        ConfigRegistries.getRegistries().addDataRegistry(FluidRarityRegistry.INSTANCE);
        ConfigRegistries.getRegistries().addDataRegistry(TechnicalEntityRegistry.INSTANCE);
        ConfigRegistries.getRegistries().addDataRegistry(TileAccelerationBlacklistRegistry.INSTANCE);
        ConfigRegistries.getRegistries().addDataRegistry(AmuletEnchantmentRegistry.INSTANCE);
        ConfigRegistries.getRegistries().addDataRegistry(WeightedPerkAttributeRegistry.INSTANCE);
        ConfigRegistries.getRegistries().addDataRegistry(OreItemRarityRegistry.VOID_TRASH_REWARD);
        ConfigRegistries.getRegistries().addDataRegistry(OreBlockRarityRegistry.STONE_ENRICHMENT);
        ConfigRegistries.getRegistries().addDataRegistry(OreBlockRarityRegistry.MINERALIS_RITUAL);
        ConfigRegistries.getRegistries().addDataRegistry(EntityTransmutationRegistry.INSTANCE);
        ToolsConfig.CONFIG.newSubSection(WandsConfig.CONFIG);
        MachineryConfig.CONFIG.newSubSection(TileTreeBeacon.Config.CONFIG);
        this.serverConfig.addConfigEntry(GeneralConfig.CONFIG);
        this.serverConfig.addConfigEntry(ToolsConfig.CONFIG);
        this.serverConfig.addConfigEntry(EntityConfig.CONFIG);
        this.serverConfig.addConfigEntry(CraftingConfig.CONFIG);
        this.serverConfig.addConfigEntry(LightNetworkConfig.CONFIG);
        this.serverConfig.addConfigEntry(LogConfig.CONFIG);
        this.serverConfig.addConfigEntry(PerkConfig.CONFIG);
        this.serverConfig.addConfigEntry(AmuletRandomizeHelper.CONFIG);
        this.serverConfig.addConfigEntry(MachineryConfig.CONFIG);
        RegistryPerks.initConfig(PerkConfig.CONFIG::newSubSection);
        this.commonConfig.addConfigEntry(CommonGeneralConfig.CONFIG);
        this.commonConfig.addConfigEntry(WorldGenConfig.CONFIG);
        RegistryWorldGeneration.addConfigEntries(WorldGenConfig.CONFIG::newSubSection);
        ConstellationEffectRegistry.addConfigEntries(this.serverConfig);
        MantleEffectRegistry.addConfigEntries(this.serverConfig);
    }

    public InternalRegistryPrimer getRegistryPrimer() {
        return this.registryPrimer;
    }

    public TickManager getTickManager() {
        return this.tickManager;
    }

    public FakePlayer getASFakePlayerServer(ServerWorld world) {
        return FakePlayerFactory.get((ServerWorld)world, (GameProfile)new GameProfile(FAKEPLAYER_UUID, "AS-FakePlayer"));
    }

    public File getASServerDataDirectory() {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (server == null) {
            return null;
        }
        File asDataDir = server.func_240776_a_(new FolderName("astralsorcery")).toFile();
        if (!asDataDir.exists()) {
            asDataDir.mkdirs();
        }
        return asDataDir;
    }

    public void scheduleClientside(Runnable r, int tickDelay) {
    }

    public void scheduleClientside(Runnable r) {
        this.scheduleClientside(r, 0);
    }

    public void scheduleDelayed(Runnable r, int tickDelay) {
        this.commonScheduler.addRunnable(r, tickDelay);
    }

    public void scheduleDelayed(Runnable r) {
        this.scheduleDelayed(r, 0);
    }

    public void openGuiClient(GuiType type, CompoundNBT data) {
    }

    public void openGui(PlayerEntity player, GuiType type, Object ... data) {
        if (player instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            PktOpenGui pkt = new PktOpenGui(type, type.serializeArguments(data));
            PacketChannel.CHANNEL.sendToPlayer(player, pkt);
        }
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        this.serverConfig.buildConfiguration();
        RegistryCapabilities.init(MinecraftForge.EVENT_BUS);
        StarlightNetworkRegistry.setupRegistry();
        CollisionManager.init();
        PatreonDataManager.loadPatreonEffects();
        event.enqueueWork(RegistryWorldGeneration::registerStructureGeneration);
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        CommandAstralSorcery.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private void onEnqueueIMC(InterModEnqueueEvent event) {
        Mods.CURIOS.executeIfPresent(() -> IntegrationCurios::initIMC);
    }

    private void onRegisterReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)PerkTreeLoader.INSTANCE);
    }

    private void onServerStarted(FMLServerStartedEvent event) {
        this.serverLifecycleListeners.forEach(ServerLifecycleListener::onServerStart);
    }

    private void onServerStarting(FMLServerStartingEvent event) {
    }

    private void onServerStopping(FMLServerStoppingEvent event) {
        this.serverLifecycleListeners.forEach(ServerLifecycleListener::onServerStop);
    }

    private void onServerStop(FMLServerStoppedEvent event) {
    }
}

