/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.resource;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.resource.GeneratedResource;
import hellfirepvp.astralsorcery.client.resource.ReloadableResource;
import hellfirepvp.astralsorcery.client.sky.astral.AstralSkyRenderer;
import hellfirepvp.astralsorcery.common.util.object.CacheReference;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class AssetLibrary
implements ISelectiveResourceReloadListener {
    public static AssetLibrary INSTANCE = new AssetLibrary();
    private static boolean reloading = false;
    private static final Map<AssetLoader.SubLocation, Map<String, AbstractRenderableTexture>> loadedTextures = new HashMap<AssetLoader.SubLocation, Map<String, AbstractRenderableTexture>>();
    private static final Map<ResourceLocation, GeneratedResource> dynamicTextures = new HashMap<ResourceLocation, GeneratedResource>();
    private static final List<ReloadableResource> reloadableResources = new ArrayList<ReloadableResource>();

    private AssetLibrary() {
    }

    public static Supplier<AbstractRenderableTexture> loadReference(AssetLoader.TextureLocation location, String ... path) {
        return new CacheReference<AbstractRenderableTexture>(() -> AssetLibrary.loadTexture(location, path));
    }

    public static AbstractRenderableTexture loadTexture(AssetLoader.TextureLocation location, String ... path) {
        String name = String.join((CharSequence)"/", path);
        if (name.endsWith(".png")) {
            throw new IllegalArgumentException("Tried to loadTexture with appended .png from the AssetLibrary!");
        }
        AbstractRenderableTexture resource = loadedTextures.computeIfAbsent(location, l -> new HashMap()).computeIfAbsent(name, str -> AssetLoader.loadTexture(location, str));
        reloadableResources.add((ReloadableResource)((Object)resource));
        return resource;
    }

    public static GeneratedResource loadGeneratedResource(ResourceLocation key, Supplier<BufferedImage> imageGenerator, boolean blur) {
        return AssetLibrary.loadGeneratedResource(key, imageGenerator, blur, false);
    }

    public static GeneratedResource loadGeneratedResource(ResourceLocation key, Supplier<BufferedImage> imageGenerator, boolean blur, boolean clamp) {
        if (dynamicTextures.containsKey(key)) {
            return dynamicTextures.get(key);
        }
        GeneratedResource resource = new GeneratedResource(key, imageGenerator, blur, clamp);
        reloadableResources.add(resource);
        dynamicTextures.put(key, resource);
        return resource;
    }

    public static boolean isReloading() {
        return reloading;
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (reloading || !resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            return;
        }
        reloading = true;
        AstralSorcery.log.info("[AssetLibrary] Refreshing and Invalidating Resources");
        reloadableResources.forEach(ReloadableResource::invalidateAndReload);
        reloading = false;
        AstralSkyRenderer.INSTANCE.reset();
        AstralSorcery.log.info("[AssetLibrary] Successfully reloaded library.");
    }
}

