/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.render;

import artifacts.client.render.curio.CurioRenderers;
import artifacts.client.render.curio.renderer.GloveCurioRenderer;
import artifacts.common.config.ModConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin {
    @Inject(method={"renderLeftHand"}, at={@At(value="TAIL")})
    private void renderLeftGlove(MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, AbstractClientPlayerEntity player, CallbackInfo callbackInfo) {
        PlayerRendererMixin.renderArm(matrixStack, buffer, light, player, HandSide.LEFT);
    }

    @Inject(method={"renderRightHand"}, at={@At(value="TAIL")})
    private void renderRightGlove(MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, AbstractClientPlayerEntity player, CallbackInfo callbackInfo) {
        PlayerRendererMixin.renderArm(matrixStack, buffer, light, player, HandSide.RIGHT);
    }

    @Unique
    private static void renderArm(MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, AbstractClientPlayerEntity player, HandSide handSide) {
        if (!((Boolean)ModConfig.client.showFirstPersonGloves.get()).booleanValue()) {
            return;
        }
        Hand hand = handSide == player.func_184591_cq() ? Hand.MAIN_HAND : Hand.OFF_HAND;
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            ICurioStacksHandler stacksHandler = (ICurioStacksHandler)handler.getCurios().get(SlotTypePreset.HANDS.getIdentifier());
            if (stacksHandler != null) {
                int slot;
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStacks = stacksHandler.getCosmeticStacks();
                int n = slot = hand == Hand.MAIN_HAND ? 0 : 1;
                while (slot < stacks.getSlots()) {
                    GloveCurioRenderer renderer;
                    ItemStack stack = cosmeticStacks.getStackInSlot(slot);
                    if (stack.func_190926_b() && ((Boolean)stacksHandler.getRenders().get(slot)).booleanValue()) {
                        stack = stacks.getStackInSlot(slot);
                    }
                    if ((renderer = CurioRenderers.getGloveRenderer(stack)) != null) {
                        renderer.renderFirstPersonArm(matrixStack, buffer, light, player, handSide, stack.func_77962_s());
                    }
                    slot += 2;
                }
            }
        });
    }
}

